/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class TotalHitCountCollector
implements Collector {
    private Weight weight;
    private int totalHits;

    public int getTotalHits() {
        return this.totalHits;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        int leafCount;
        int n = leafCount = this.weight == null ? -1 : this.weight.count(context);
        if (leafCount != -1) {
            this.totalHits += leafCount;
            throw new CollectionTerminatedException();
        }
        return this.createLeafCollector();
    }

    protected final LeafCollector createLeafCollector() {
        return new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) {
            }

            @Override
            public void collect(int doc) {
                ++TotalHitCountCollector.this.totalHits;
            }

            @Override
            public void collect(DocIdStream stream) throws IOException {
                TotalHitCountCollector.this.totalHits += stream.count();
            }
        };
    }
}

