/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class AnnotationHoverDelegate
implements ITextHover {
    private DefaultTextHover delegate;
    private ISourceViewer viewer;

    private DefaultTextHover getDelegate(ISourceViewer sourceViewer) {
        if (this.delegate == null || this.viewer != sourceViewer) {
            this.delegate = new DefaultTextHover(sourceViewer){

                protected boolean isIncluded(Annotation annotation) {
                    if (annotation instanceof MarkerAnnotation) {
                        return false;
                    }
                    AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
                    if (preference == null) {
                        return false;
                    }
                    String key = preference.getTextPreferenceKey();
                    return !(key != null ? !EditorsUI.getPreferenceStore().getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !EditorsUI.getPreferenceStore().getBoolean(key));
                }
            };
            this.viewer = sourceViewer;
        }
        return this.delegate;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer instanceof ISourceViewer) {
            return this.getDelegate((ISourceViewer)textViewer).getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer instanceof ISourceViewer) {
            return this.getDelegate((ISourceViewer)textViewer).getHoverRegion(textViewer, offset);
        }
        return null;
    }
}

