/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class UserAuthGSS
extends AbstractUserAuth {
    public static final String NAME = "gssapi-with-mic";
    public static final Oid KRB5_MECH = UserAuthGSS.createOID("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL = UserAuthGSS.createOID("1.2.840.113554.1.2.2.1");
    private GSSContext context;
    private String identity;

    public UserAuthGSS() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean initial) throws Exception {
        ServerSession session = this.getServerSession();
        GSSAuthenticator auth = Objects.requireNonNull(session.getGSSAuthenticator(), "No GSSAuthenticator configured");
        String user = this.getUsername();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (initial) {
            int num = buffer.getInt();
            if (num < 0 || num > 32768) {
                this.log.error("doAuth({}@{}) Illogical OID entries count: {}", new Object[]{user, session, num});
                throw new IndexOutOfBoundsException("Illogical OID entries count: " + num);
            }
            boolean traceEnabled = this.log.isTraceEnabled();
            for (int i = 1; i <= num; ++i) {
                Oid oid = new Oid(buffer.getBytes());
                if (!oid.equals(KRB5_MECH)) {
                    if (!traceEnabled) continue;
                    this.log.trace("doAuth({}@{}) skip OID {}/{}: {}", new Object[]{user, session, i, num, oid});
                    continue;
                }
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) found Kerberos 5 after {}/{} OID(s)", new Object[]{user, session, i, num});
                }
                if (!auth.validateInitialUser(session, user)) {
                    return Boolean.FALSE;
                }
                GSSManager mgr = auth.getGSSManager();
                GSSCredential creds = auth.getGSSCredential(mgr);
                if (creds == null) {
                    return Boolean.FALSE;
                }
                this.context = mgr.createContext(creds);
                byte[] out = oid.getDER();
                Buffer b = session.createBuffer((byte)60, out.length + 32);
                b.putBytes(out);
                session.writePacket(b);
                return null;
            }
            return Boolean.FALSE;
        }
        int msg = buffer.getUByte();
        if (!(msg == 61 || msg == 66 && this.context.isEstablished())) {
            throw new SshException(2, "Packet not supported by user authentication method: " + SshConstants.getCommandMessageName(msg));
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) In krb5.next: msg = {}", new Object[]{user, session, SshConstants.getCommandMessageName(msg)});
        }
        if (this.context.isEstablished()) {
            if (msg != 66) {
                return Boolean.FALSE;
            }
            ByteArrayBuffer msgbuf = new ByteArrayBuffer();
            msgbuf.putBytes(ValidateUtils.checkNotNullAndNotEmpty(session.getSessionId(), "No current session ID"));
            ((Buffer)msgbuf).putByte((byte)50);
            msgbuf.putString(this.getUsername());
            msgbuf.putString(this.getService());
            msgbuf.putString(this.getName());
            byte[] msgbytes = msgbuf.getCompactData();
            byte[] inmic = buffer.getBytes();
            try {
                this.context.verifyMIC(inmic, 0, inmic.length, msgbytes, 0, msgbytes.length, new MessageProp(false));
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) MIC verified", (Object)this.getUsername(), (Object)session);
                }
                return Boolean.TRUE;
            }
            catch (GSSException e) {
                if (debugEnabled) {
                    this.log.debug("doAuth({}@{}) GSS verification {} error: {}", new Object[]{user, session, e.getClass().getSimpleName(), e.getMessage()});
                }
                return Boolean.FALSE;
            }
        }
        byte[] tok = buffer.getBytes();
        byte[] out = this.context.acceptSecContext(tok, 0, tok.length);
        boolean established = this.context.isEstablished();
        if (established && this.identity == null) {
            GSSName srcName = this.context.getSrcName();
            this.identity = srcName.toString();
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) GSS identity is {}", new Object[]{user, session, this.identity});
            }
            if (!auth.validateIdentity(session, this.identity)) {
                return Boolean.FALSE;
            }
        }
        if (NumberUtils.length(out) > 0) {
            Buffer b = session.createBuffer((byte)61, out.length + 32);
            b.putBytes(out);
            session.writePacket(b);
            return null;
        }
        return established;
    }

    @Override
    public void destroy() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed ({}) to dispose of context: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                }
            }
            finally {
                this.context = null;
            }
        }
    }

    public static Oid createOID(String rep) {
        try {
            return new Oid(rep);
        }
        catch (GSSException e) {
            return null;
        }
    }
}

