/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.runtime;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rcptt.ecl.internal.debug.runtime.Log;
import org.eclipse.rcptt.ecl.internal.debug.runtime.ServerSession;

public class DebugServer {
    private static final Map<String, DebugServer> servers = new ConcurrentHashMap<String, DebugServer>();
    private final ServerSocket socket;
    private final String id;
    private ServerSession transport;
    private boolean terminated;

    public static DebugServer start(String id) throws IOException {
        DebugServer server = new DebugServer(id);
        servers.put(id, server);
        return server;
    }

    public static DebugServer get(String id) {
        return servers.get(id);
    }

    public String getId() {
        return this.id;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public void stop() {
        servers.remove(this.getId());
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.terminate();
    }

    private DebugServer(String id) throws IOException {
        this.id = id;
        this.socket = new ServerSocket(0);
        new Thread(){

            @Override
            public void run() {
                DebugServer.this.accept();
            }
        }.start();
    }

    private void accept() {
        try {
            if (this.isTerminated()) {
                return;
            }
            this.transport = new ServerSession(this.socket.accept(), this.id);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    private synchronized void terminate() {
        this.terminated = true;
        if (this.transport != null) {
            this.transport.terminate();
        }
    }

    private synchronized boolean isTerminated() {
        return this.terminated;
    }
}

