/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class SignedIntegerRendering
extends AbstractIntegerRendering {
    private int fColSize;
    private BigInteger fMax;
    private BigInteger fMin;

    public SignedIntegerRendering(String renderingId) {
        super(renderingId);
    }

    private String convertToString(byte[] byteArray, int columnSize, int endianess) {
        long result = 0L;
        switch (columnSize) {
            case 1: {
                result = byteArray[0];
                break;
            }
            case 2: {
                result = RenderingsUtil.convertByteArrayToShort(byteArray, endianess, this.getAddressableSize());
                break;
            }
            case 4: {
                result = RenderingsUtil.convertByteArrayToInt(byteArray, endianess, this.getAddressableSize());
                break;
            }
            case 8: {
                result = RenderingsUtil.convertByteArrayToLong(byteArray, endianess, this.getAddressableSize());
                break;
            }
            case 16: {
                BigInteger bigRet = RenderingsUtil.convertByteArrayToSignedBigInt(byteArray, endianess, this.getAddressableSize());
                return bigRet.toString();
            }
            default: {
                BigInteger bigRet = RenderingsUtil.convertByteArrayToSignedBigInt(byteArray, endianess, columnSize, this.getAddressableSize());
                return bigRet.toString();
            }
        }
        String ret = Long.toString(result);
        return ret;
    }

    private byte[] convertToBytes(int colSize, String newValue, int endianess) {
        byte[] bytes;
        switch (colSize) {
            case 1: {
                byte x = Byte.parseByte(newValue);
                bytes = new byte[]{x};
                break;
            }
            case 2: {
                short i = Short.parseShort(newValue);
                bytes = RenderingsUtil.convertShortToByteArray(i, endianess, this.getAddressableSize());
                break;
            }
            case 4: {
                int i = Integer.parseInt(newValue);
                bytes = RenderingsUtil.convertIntToByteArray(i, endianess, this.getAddressableSize());
                break;
            }
            case 8: {
                long i = Long.parseLong(newValue);
                bytes = RenderingsUtil.convertLongToByteArray(i, endianess, this.getAddressableSize());
                break;
            }
            case 16: {
                BigInteger i = new BigInteger(newValue);
                byte[] bytes2 = RenderingsUtil.convertBigIntegerToByteArray(i, endianess, this.getAddressableSize());
                return bytes2;
            }
            default: {
                BigInteger i = new BigInteger(newValue);
                if (this.fColSize != colSize) {
                    this.fColSize = colSize;
                    this.fMax = BigInteger.valueOf(2L);
                    this.fMax = this.fMax.pow(colSize * 8 - 1);
                    this.fMin = this.fMax.multiply(BigInteger.valueOf(-1L));
                    this.fMax = this.fMax.subtract(BigInteger.valueOf(1L));
                }
                if (i.compareTo(this.fMax) > 0 || i.compareTo(this.fMin) < 0) {
                    throw new NumberFormatException();
                }
                byte[] bytes3 = RenderingsUtil.convertSignedBigIntToByteArray(i, endianess, colSize, this.getAddressableSize());
                return bytes3;
            }
        }
        return bytes;
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        boolean invalid = false;
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        MemoryByte[] memoryByteArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryByte memByte = memoryByteArray[n2];
            if (!memByte.isReadable()) {
                invalid = true;
                break;
            }
            ++n2;
        }
        if (invalid) {
            StringBuilder strBuf = new StringBuilder();
            int i = 0;
            while (i < data.length) {
                strBuf.append(paddedStr);
                ++i;
            }
            return strBuf.toString();
        }
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(data);
        }
        byte[] byteArray = new byte[data.length];
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = data[i].getValue();
            ++i;
        }
        if (2 == endianess) {
            StringBuilder strBuf = new StringBuilder();
            int i2 = 0;
            while (i2 < byteArray.length) {
                strBuf.append(paddedStr);
                ++i2;
            }
            return strBuf.toString();
        }
        return this.convertToString(byteArray, columnSize, endianess);
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(currentValues);
        }
        if (endianess == 2) {
            byte[] retBytes = new byte[currentValues.length];
            int i = 0;
            while (i < currentValues.length) {
                retBytes[i] = currentValues[i].getValue();
                ++i;
            }
            return retBytes;
        }
        return this.convertToBytes(columnSize, data, endianess);
    }
}

