/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class SelectFavoritesDialog
extends AbstractDebugCheckboxSelectionDialog {
    private final LaunchHistory fHistory;
    private final List<ILaunchConfiguration> fCurrentFavoriteSet;

    public SelectFavoritesDialog(Shell parentShell, LaunchHistory history, List<ILaunchConfiguration> favorites) {
        super(parentShell);
        this.fHistory = history;
        this.fCurrentFavoriteSet = favorites;
        this.setTitle(MessageFormat.format(LaunchConfigurationsMessages.FavoritesDialog_0, this.getModeLabel()));
        this.setShowSelectAllButtons(true);
    }

    private String getModeLabel() {
        return DebugUIPlugin.removeAccelerators(this.fHistory.getLaunchGroup().getLabel());
    }

    @Override
    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_FAVORITESS_DIALOG";
    }

    @Override
    protected Object getViewerInput() {
        return this.fHistory.getLaunchGroup().getMode();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new LaunchConfigurationContentProvider();
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_favorites_dialog";
    }

    @Override
    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.FavoritesDialog_7;
    }

    protected class LaunchConfigurationContentProvider
    implements IStructuredContentProvider {
        protected LaunchConfigurationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] all = null;
            try {
                all = LaunchConfigurationManager.filterConfigs(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return new ILaunchConfiguration[0];
            }
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>(all.length);
            LaunchGroupFilter filter = new LaunchGroupFilter(SelectFavoritesDialog.this.fHistory.getLaunchGroup());
            ILaunchConfiguration[] iLaunchConfigurationArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (filter.select(null, null, config)) {
                    list.add(config);
                }
                ++n2;
            }
            list.removeAll(SelectFavoritesDialog.this.fCurrentFavoriteSet);
            Object[] objs = list.toArray();
            new WorkbenchViewerComparator().sort((Viewer)SelectFavoritesDialog.this.getCheckBoxTableViewer(), objs);
            return objs;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

