/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleFailuresError
extends AssertionError {
    private static final long serialVersionUID = 1L;
    private static final String EOL = System.getProperty("line.separator");
    private final String heading;
    private final List<Throwable> failures;

    public MultipleFailuresError(String heading, List<? extends Throwable> failures) {
        if (failures == null) {
            throw new NullPointerException("failures must not be null");
        }
        this.heading = MultipleFailuresError.isBlank(heading) ? "Multiple Failures" : heading.trim();
        this.failures = new ArrayList<Throwable>();
        for (Throwable throwable : failures) {
            if (throwable == null) {
                throw new NullPointerException("failures must not contain null elements");
            }
            this.failures.add(throwable);
        }
    }

    public String getMessage() {
        int failureCount = this.failures.size();
        if (failureCount == 0) {
            return this.heading;
        }
        StringBuilder builder = new StringBuilder(this.heading).append(" (").append(failureCount).append(" ").append(MultipleFailuresError.pluralize(failureCount, "failure", "failures")).append(")").append(EOL);
        int lastIndex = failureCount - 1;
        for (Throwable failure : this.failures.subList(0, lastIndex)) {
            builder.append("\t").append(MultipleFailuresError.nullSafeMessage(failure)).append(EOL);
        }
        builder.append('\t').append(MultipleFailuresError.nullSafeMessage(this.failures.get(lastIndex)));
        return builder.toString();
    }

    public List<Throwable> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String pluralize(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }

    private static String nullSafeMessage(Throwable failure) {
        if (MultipleFailuresError.isBlank(failure.getMessage())) {
            return failure.getClass().getName() + ": <no message>";
        }
        return failure.getClass().getName() + ": " + failure.getMessage();
    }
}

