/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.search.internal.ui.text.FileMatch;

public class LineItem {
    IFile f;
    String line;
    int lineNumber;
    int lineOffset;

    public LineItem(IFile f, String line, int lineNumber, int lineOffset) {
        this.f = this.getInnermostProjectFile(f);
        this.line = line;
        this.lineNumber = lineNumber;
        this.lineOffset = lineOffset;
    }

    public LineItem(FileMatch match) {
        this.f = this.getInnermostProjectFile(match.getFile());
        this.line = match.getLineElement().getContents();
        this.lineNumber = match.getLineElement().getLine();
        this.lineOffset = match.getLineElement().getOffset();
    }

    private IFile getInnermostProjectFile(IFile file) {
        URI locationUri = file.getLocationURI();
        return locationUri == null ? file : Arrays.stream(file.getWorkspace().getRoot().findFilesForLocationURI(locationUri)).min(Comparator.comparingInt(aFile -> aFile.getFullPath().segments().length)).orElse(file);
    }

    public String toString() {
        return this.lineNumber + ": " + this.line + "  (" + String.valueOf(this.f.getProjectRelativePath()) + ")";
    }

    public String getText() {
        return this.line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IFile getFile() {
        return this.f;
    }

    public int hashCode() {
        return Objects.hash(this.f, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineItem other = (LineItem)obj;
        if (!Objects.equals(this.f, other.f)) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }

    public int getOffset() {
        return this.lineOffset;
    }
}

