/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;

public class Bundle
extends BundleObject
implements IBundle {
    private static final long serialVersionUID = 1L;
    private final Map<String, IManifestHeader> fDocumentHeaders = new ConcurrentSkipListMap<String, IManifestHeader>(String::compareToIgnoreCase);

    @Override
    public void setHeader(String key, String value) {
        if (value == null) {
            IManifestHeader header = this.fDocumentHeaders.remove(key);
            if (header != null) {
                this.getModel().fireModelObjectChanged(header, key, header.getValue(), null);
            }
        } else {
            IManifestHeader header = this.fDocumentHeaders.get(key);
            if (header == null) {
                header = this.getModel().getFactory().createHeader(key, value);
                this.fDocumentHeaders.put(key, header);
                this.getModel().fireModelObjectChanged(header, key, null, value);
            } else {
                String old = header.getValue();
                header.setValue(value);
                this.getModel().fireModelObjectChanged(header, key, old, value);
            }
        }
    }

    @Override
    public String getHeader(String key) {
        ManifestHeader header = (ManifestHeader)this.fDocumentHeaders.get(key);
        return header != null ? header.getValue() : null;
    }

    public void load(Map<String, String> headers) {
        this.fDocumentHeaders.clear();
        for (String key : headers.keySet()) {
            if (headers.get(key) == null) continue;
            String value = headers.get(key);
            IManifestHeader header = this.getModel().getFactory().createHeader(key, value);
            header.update();
            this.fDocumentHeaders.put(key, header);
        }
    }

    @Override
    public String getLocalization() {
        String localization = this.getHeader("Bundle-Localization");
        return localization != null ? localization : "OSGI-INF/l10n/bundle";
    }

    @Override
    public void renameHeader(String key, String newKey) {
        ManifestHeader header = (ManifestHeader)this.getManifestHeader(key);
        if (header != null) {
            header.setName(newKey);
            this.fDocumentHeaders.put(newKey, this.fDocumentHeaders.remove(key));
        }
        this.getModel().fireModelObjectChanged(header, newKey, key, newKey);
    }

    @Override
    public IManifestHeader getManifestHeader(String key) {
        return this.fDocumentHeaders.get(key);
    }

    @Override
    public Map<String, IManifestHeader> getManifestHeaders() {
        ConcurrentSkipListMap<String, IManifestHeader> copy = new ConcurrentSkipListMap<String, IManifestHeader>(String::compareToIgnoreCase);
        copy.putAll(this.fDocumentHeaders);
        return copy;
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> result = new HashMap<String, String>(this.fDocumentHeaders.size());
        for (IManifestHeader header : this.fDocumentHeaders.values()) {
            if (header.getValue() == null) continue;
            result.put(header.getKey(), header.getValue());
        }
        return result;
    }
}

