/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class URLDialog
extends TitleAreaDialog {
    private String locationStr = null;
    private URI location = null;
    private String name = null;
    private final String title;
    private final boolean named;

    public URLDialog(Shell parentShell, String title) {
        this(parentShell, title, true);
    }

    public URLDialog(Shell parentShell, String title, boolean named) {
        super(parentShell);
        this.title = title;
        this.named = named;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout(3, false);
        container.setLayout((Layout)gl);
        Label lblUrl = new Label(container, 0);
        lblUrl.setText("URL:");
        final Text txtUrl = new Text(container, 2048);
        txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtUrl.addModifyListener(ev -> {
            this.locationStr = txtUrl.getText();
            this.updateFromInput();
        });
        Button btnBrowseFile = new Button(container, 8);
        btnBrowseFile.setText("Local File");
        btnBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(URLDialog.this.getShell(), 4096);
                String path = fileDialog.open();
                if (path != null) {
                    File file = new File(path);
                    URI fileUri = file.toURI();
                    txtUrl.setText(fileUri.toString());
                }
            }
        });
        if (this.named) {
            new Label(container, 0).setText("Name:");
            Text txtName = new Text(container, 2048);
            txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label lblSpacer1 = new Label(container, 0);
            txtName.addModifyListener(ev -> {
                String string = this.name = txtName.getText();
            });
        }
        if (this.location != null) {
            txtUrl.setText(this.location.toString());
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText("Add");
        ok.setEnabled(this.location != null);
    }

    private void updateFromInput() {
        try {
            this.location = new URI(this.locationStr);
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(e.getMessage());
            this.getButton(0).setEnabled(false);
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }
}

