/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.EngineTypeDescriptor;
import org.eclipse.help.ui.internal.views.NewEngineWizard;
import org.eclipse.help.ui.internal.views.ScopePreferenceManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScopePreferenceDialog
extends PreferenceDialog {
    private final EngineDescriptorManager descManager;
    private ArrayList<PendingOperation> pendingOperations;
    private static final int NEW_ID = 1025;
    private static final int DELETE_ID = 1026;

    public ScopePreferenceDialog(Shell parentShell, PreferenceManager manager, EngineDescriptorManager descManager, boolean editable) {
        super(parentShell, manager);
        this.descManager = descManager;
    }

    protected Control createTreeAreaContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        Control treeControl = super.createTreeAreaContents(container);
        GridData treeGd = (GridData)treeControl.getLayoutData();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        treeControl.setLayoutData((Object)gd);
        Button lbutton = this.createButton(container, 1025, Messages.ScopePreferenceDialog_new, false);
        gd = (GridData)lbutton.getLayoutData();
        gd.horizontalAlignment = 32;
        Button rbutton = this.createButton(container, 1026, Messages.ScopePreferenceDialog_delete, false);
        rbutton.setEnabled(false);
        gd = (GridData)rbutton.getLayoutData();
        gd.horizontalAlignment = 32;
        layout.numColumns = 2;
        container.setLayoutData((Object)treeGd);
        Point size = container.computeSize(-1, -1, true);
        treeGd.widthHint = Math.max(treeGd.widthHint, size.x);
        return container;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection ssel = event.getStructuredSelection();
            Object obj = ssel.getFirstElement();
            this.treeSelectionChanged(obj);
        });
        return viewer;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.doNew();
                break;
            }
            case 1026: {
                this.doDelete();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private void treeSelectionChanged(Object obj) {
        boolean removable = false;
        if (obj instanceof ScopePreferenceManager.EnginePreferenceNode) {
            ScopePreferenceManager.EnginePreferenceNode node = (ScopePreferenceManager.EnginePreferenceNode)((Object)obj);
            EngineDescriptor desc = node.getDescriptor();
            removable = desc.isUserDefined();
        }
        this.getButton(1026).setEnabled(removable);
    }

    private void doNew() {
        NewEngineWizard wizard = new NewEngineWizard(this.descManager.getEngineTypes());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(400, 500);
        if (dialog.open() == 0) {
            EngineTypeDescriptor etdesc = wizard.getSelectedEngineType();
            EngineDescriptor desc = new EngineDescriptor(this.descManager);
            desc.setEngineType(etdesc);
            desc.setUserDefined(true);
            desc.setId(this.descManager.computeNewId(etdesc.getId()));
            ScopePreferenceManager mng = (ScopePreferenceManager)this.getPreferenceManager();
            IPreferenceNode node = mng.addNode(desc);
            this.getTreeViewer().refresh();
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
            this.scheduleOperation(1025, desc);
        }
    }

    private void doDelete() {
        Object obj = this.getTreeViewer().getStructuredSelection().getFirstElement();
        if (obj instanceof ScopePreferenceManager.EnginePreferenceNode) {
            ScopePreferenceManager.EnginePreferenceNode node = (ScopePreferenceManager.EnginePreferenceNode)((Object)obj);
            EngineDescriptor desc = node.getDescriptor();
            this.getTreeViewer().remove((Object)node);
            this.scheduleOperation(1026, desc);
        }
    }

    private void scheduleOperation(int action, EngineDescriptor desc) {
        if (this.pendingOperations == null) {
            this.pendingOperations = new ArrayList();
        }
        this.pendingOperations.add(new PendingOperation(action, desc));
    }

    protected void okPressed() {
        super.okPressed();
        if (this.pendingOperations != null) {
            int i = 0;
            while (i < this.pendingOperations.size()) {
                PendingOperation op = this.pendingOperations.get(i);
                if (op.action == 1025) {
                    this.descManager.add(op.desc);
                } else {
                    this.descManager.remove(op.desc);
                }
                ++i;
            }
            this.pendingOperations = null;
        }
        this.descManager.save();
    }

    static class PendingOperation {
        int action;
        EngineDescriptor desc;

        public PendingOperation(int action, EngineDescriptor desc) {
            this.action = action;
            this.desc = desc;
        }
    }
}

