/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.server.tcp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.IMarkeredPipe;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.EclRuntime;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

final class SessionRequestHandler
implements Runnable {
    private final Socket socket;
    private final ISession session;
    private final BufferedInputStream inputStream;
    private final int defaultTimeout;

    SessionRequestHandler(Socket socket, boolean useJobs, Map<String, Object> properties) throws IOException {
        this.socket = socket;
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            CorePlugin.log((Throwable)e);
        }
        this.session = EclRuntime.createSession((boolean)useJobs);
        properties.forEach((arg_0, arg_1) -> ((ISession)this.session).putProperty(arg_0, arg_1));
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.defaultTimeout = socket.getSoTimeout();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                IMarkeredPipe pipe = CoreUtils.createEMFPipe((InputStream)this.inputStream, (OutputStream)this.socket.getOutputStream());
                while (!Thread.currentThread().isInterrupted()) {
                    if (this.socket.isClosed()) {
                        return;
                    }
                    try {
                        IStatus status;
                        pipe.reinit();
                        Object object = pipe.take(Long.MAX_VALUE);
                        if (!(object instanceof Command)) {
                            return;
                        }
                        Command command = (Command)object;
                        try {
                            IPipe input = this.readInput((IPipe)pipe);
                            IProcess process = this.session.execute(command, input, null);
                            status = this.writeOutput((IPipe)pipe, process);
                        }
                        catch (CoreException e) {
                            status = e.getStatus();
                        }
                        try {
                            pipe.write((Object)status);
                        }
                        catch (ClassCastException e) {
                            CorePlugin.log((Throwable)e);
                            status = CorePlugin.err((Throwable)e);
                            pipe.write((Object)status);
                        }
                        pipe.close(status);
                    }
                    catch (Exception e) {
                        Throwable te = e;
                        if (e instanceof CoreException && e.getCause() instanceof SocketException) {
                            te = e.getCause();
                        }
                        if (te instanceof SocketException) {
                            try {
                                this.socket.close();
                                return;
                            }
                            catch (IOException iOException) {
                                return;
                            }
                        }
                        CorePlugin.log((Throwable)e);
                    }
                }
                return;
            }
            catch (Exception e) {
                CorePlugin.log((Throwable)e);
                try {
                    this.socket.close();
                }
                catch (Exception e2) {
                    CorePlugin.log((Throwable)e2);
                }
                try {
                    this.session.close();
                    return;
                }
                catch (Exception e3) {
                    CorePlugin.log((Throwable)e3);
                    return;
                }
            }
        }
        finally {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                CorePlugin.log((Throwable)e);
            }
            try {
                this.session.close();
            }
            catch (Exception e) {
                CorePlugin.log((Throwable)e);
            }
        }
    }

    private IPipe readInput(IPipe pipe) throws CoreException {
        Object object;
        IPipe input = this.session.createPipe();
        while (true) {
            if ((object = pipe.take(Long.MAX_VALUE)) instanceof IStatus) break;
            input.write(object);
        }
        input.close((IStatus)object);
        return input;
    }

    private IStatus writeOutput(IPipe pipe, IProcess process) throws CoreException, IOException {
        while (true) {
            Object object;
            if ((object = process.getOutput().take(100L)) == null) {
                if (this.isConnected()) continue;
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (object instanceof IStatus) {
                try {
                    return process.waitFor();
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
            }
            pipe.write(object);
        }
    }

    private boolean isConnected() throws IOException {
        this.inputStream.mark(10);
        this.socket.setSoTimeout(1);
        try {
            boolean bl = this.inputStream.read() >= 0 && this.inputStream.read() >= 0;
            return bl;
        }
        catch (SocketTimeoutException e) {
            return true;
        }
        finally {
            this.socket.setSoTimeout(this.defaultTimeout);
            this.inputStream.reset();
        }
    }

    public void recover(Socket client) {
    }
}

