/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.contentassist.CurrentFrameContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class ExpressionInputDialog
extends TrayDialog {
    protected IJavaVariable fVariable;
    protected String fResult = null;
    protected Composite fInputArea;
    protected Composite fSourceViewerComposite;
    protected JDISourceViewer fSourceViewer;
    protected IContentAssistProcessor fCompletionProcessor;
    protected IDocumentListener fDocumentListener;
    protected IHandlerService fService;
    protected IHandlerActivation fActivation;
    protected Text fErrorText;

    protected ExpressionInputDialog(Shell parentShell, IJavaVariable variable) {
        super(parentShell);
        this.setShellStyle(1232);
        this.fVariable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.EXPRESSION_INPUT_DIALOG);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fInputArea = this.createInputArea(composite);
        this.fErrorText = this.createErrorText(composite);
        this.populateInputArea(this.fInputArea);
        return composite;
    }

    protected Text createErrorText(Composite parent) {
        Text text = SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)"");
        text.setBackground(text.getDisplay().getSystemColor(22));
        return text;
    }

    protected Composite createInputArea(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void populateInputArea(Composite parent) {
        this.fSourceViewerComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        String name = ActionMessages.ExpressionInputDialog_3;
        try {
            name = this.fVariable.getName();
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        SWTFactory.createWrapLabel((Composite)this.fSourceViewerComposite, (String)NLS.bind((String)ActionMessages.ExpressionInputDialog_0, (Object)name), (int)1, (int)this.convertHorizontalDLUsToPixels(300));
        this.fSourceViewer = new JDISourceViewer(this.fSourceViewerComposite, null, 2816);
        this.fSourceViewer.setInput(this.fSourceViewerComposite);
        this.configureSourceViewer();
        this.fSourceViewer.doOperation(7);
    }

    protected void setSourceViewerVisible(boolean value) {
        if (this.fSourceViewerComposite != null) {
            this.fSourceViewerComposite.setVisible(value);
            GridData data = (GridData)this.fSourceViewerComposite.getLayoutData();
            boolean bl = data.exclude = !value;
            if (value) {
                this.fSourceViewer.getDocument().addDocumentListener(this.fDocumentListener);
                this.activateHandler();
            } else if (this.fActivation != null) {
                this.fSourceViewer.getDocument().removeDocumentListener(this.fDocumentListener);
                this.fService.deactivateHandler(this.fActivation);
            }
        }
    }

    private void configureSourceViewer() {
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fSourceViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            @Override
            public IContentAssistProcessor getContentAssistantProcessor() {
                return ExpressionInputDialog.this.getCompletionProcessor();
            }
        });
        this.fSourceViewer.setEditable(true);
        this.fSourceViewer.setDocument((IDocument)document);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(10);
        this.fSourceViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.fSourceViewer);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        gd = (GridData)this.fSourceViewer.getControl().getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        document.set(this.getInitialText(this.fVariable));
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                ExpressionInputDialog.this.refreshValidState((TextViewer)ExpressionInputDialog.this.fSourceViewer);
            }
        };
        this.fSourceViewer.getDocument().addDocumentListener(this.fDocumentListener);
        this.activateHandler();
    }

    private void activateHandler() {
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                ExpressionInputDialog.this.fSourceViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
        this.fActivation = this.fService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
    }

    protected String getInitialText(IJavaVariable variable) {
        try {
            IValue value;
            String signature = variable.getSignature();
            if (signature.equals("Ljava/lang/String;") && !((value = variable.getValue()) instanceof JDINullValue)) {
                String currentValue = value.getValueString();
                StringBuilder buffer = new StringBuilder(currentValue.length());
                buffer.append('\"');
                char[] chars = currentValue.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    char c = chars[i];
                    switch (c) {
                        case '\b': {
                            buffer.append("\\b");
                            break;
                        }
                        case '\t': {
                            buffer.append("\\t");
                            break;
                        }
                        case '\n': {
                            buffer.append("\\n");
                            break;
                        }
                        case '\f': {
                            buffer.append("\\f");
                            break;
                        }
                        case '\r': {
                            buffer.append("\\r");
                            break;
                        }
                        case '\"': {
                            buffer.append("\\\"");
                            break;
                        }
                        case '\'': {
                            buffer.append("\\'");
                            break;
                        }
                        case '\\': {
                            buffer.append("\\\\");
                            break;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                    ++i;
                }
                buffer.append('\"');
                return buffer.toString();
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }

    protected IContentAssistProcessor getCompletionProcessor() {
        if (this.fCompletionProcessor == null) {
            this.fCompletionProcessor = new JavaDebugContentAssistProcessor(new CurrentFrameContext());
        }
        return this.fCompletionProcessor;
    }

    protected void refreshValidState(TextViewer viewer) {
        String errorMessage = null;
        if (viewer != null) {
            boolean valid;
            String text = viewer.getDocument().get();
            boolean bl = valid = text != null && text.trim().length() > 0;
            if (!valid) {
                errorMessage = ActionMessages.ExpressionInputDialog_1;
            }
        }
        this.setErrorMessage(errorMessage);
    }

    protected void refreshValidState() {
        this.refreshValidState((TextViewer)this.fSourceViewer);
    }

    protected void setErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.fErrorText.setText(message);
        this.getButton(0).setEnabled(message.length() == 0);
    }

    protected void okPressed() {
        this.fResult = this.getText();
        super.okPressed();
    }

    protected String getText() {
        return this.fSourceViewer.getDocument().get();
    }

    public String getResult() {
        return this.fResult;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ActionMessages.ExpressionInputDialog_2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshValidState();
    }

    public boolean close() {
        if (this.fActivation != null) {
            this.fService.deactivateHandler(this.fActivation);
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fSourceViewer.dispose();
            this.fSourceViewer = null;
        }
        if (this.fSourceViewerComposite != null) {
            this.fSourceViewerComposite.dispose();
            this.fSourceViewerComposite = null;
        }
        this.fDocumentListener = null;
        this.fCompletionProcessor = null;
        return super.close();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return "EXPRESSION_INPUT_DIALOG";
    }
}

