/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.filediff;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jgit.lib.Repository;

public class FileDiffPropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof FileDiff)) {
            return false;
        }
        FileDiff diff = (FileDiff)receiver;
        switch (property) {
            case "isSubmodule": {
                return this.computeResult(expectedValue, diff.isSubmodule());
            }
            case "isChange": {
                if (args == null || args.length == 0) {
                    return false;
                }
                String expected = diff.getChange().name();
                boolean matches = false;
                Object[] objectArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    if (arg != null && expected.equalsIgnoreCase(arg.toString())) {
                        matches = true;
                        break;
                    }
                    ++n2;
                }
                return this.computeResult(expectedValue, matches);
            }
            case "existsInWorktree": {
                boolean result = false;
                Repository repo = diff.getRepository();
                if (repo != null && !repo.isBare()) {
                    String path = new Path(repo.getWorkTree().getAbsolutePath()).append(diff.getPath()).toOSString();
                    result = new File(path).exists();
                }
                return this.computeResult(expectedValue, result);
            }
        }
        return false;
    }
}

