/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.core.resources.IMarker;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffEditor;
import org.eclipse.egit.ui.internal.commit.DiffEditorOutlinePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;

public class DiffEditorPage
extends DiffEditor
implements IFormPage {
    private FormEditor formEditor;
    private String title;
    private String pageId;
    private int pageIndex = -1;

    public DiffEditorPage(FormEditor editor, String id, String title) {
        this.pageId = id;
        this.title = title;
        this.setPartName(title);
        this.initialize(editor);
    }

    public DiffEditorPage(FormEditor editor) {
        this(editor, "diffPage", UIText.DiffEditor_Title);
    }

    @Override
    public void dispose() {
        DiffEditorOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.dispose();
            outlinePage = null;
        }
        super.dispose();
    }

    @Override
    protected void setSelectionAndActivate(ISelection selection, boolean activate) {
        if (activate) {
            FormEditor editor = this.getEditor();
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.setActivePage(this.getId());
        }
        this.doSetSelection(selection);
    }

    public String getTitle() {
        return this.title;
    }

    public void initialize(FormEditor editor) {
        this.formEditor = editor;
    }

    public FormEditor getEditor() {
        return this.formEditor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
        if (active) {
            this.setFocus();
        }
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals(this.formEditor.getActivePageInstance());
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public Control getPartControl() {
        return this.getSourceViewer().getTextWidget();
    }

    public String getId() {
        return this.pageId;
    }

    public int getIndex() {
        return this.pageIndex;
    }

    public void setIndex(int index) {
        this.pageIndex = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        if (object instanceof ISelection) {
            this.doSetSelection((ISelection)object);
            return true;
        }
        return false;
    }
}

