/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;

class QueryManager {
    private List<ISearchQuery> fQueries;
    private List<IQueryListener> fListeners = new ArrayList<IQueryListener>();

    public QueryManager() {
        this.fQueries = new LinkedList<ISearchQuery>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQueries() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return !this.fQueries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return this.fQueries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISearchQuery[] getQueries() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            return this.fQueries.toArray(new ISearchQuery[this.fQueries.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            this.fQueries.remove(query);
        }
        this.fireRemoved(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            if (this.fQueries.contains(query)) {
                return;
            }
            this.fQueries.add(0, query);
        }
        this.fireAdded(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryListener(IQueryListener l) {
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryListener(IQueryListener l) {
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAdded(ISearchQuery query) {
        HashSet<IQueryListener> copiedListeners = new HashSet<IQueryListener>();
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        for (IQueryListener l : copiedListeners) {
            l.queryAdded(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoved(ISearchQuery query) {
        HashSet<IQueryListener> copiedListeners = new HashSet<IQueryListener>();
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        for (IQueryListener l : copiedListeners) {
            l.queryRemoved(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStarting(ISearchQuery query) {
        HashSet<IQueryListener> copiedListeners = new HashSet<IQueryListener>();
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        for (IQueryListener l : copiedListeners) {
            l.queryStarting(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFinished(ISearchQuery query) {
        HashSet<IQueryListener> copiedListeners = new HashSet<IQueryListener>();
        List<IQueryListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        for (IQueryListener l : copiedListeners) {
            l.queryFinished(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            List<ISearchQuery> old = this.fQueries;
            this.fQueries = new LinkedList<ISearchQuery>();
            for (ISearchQuery element : old) {
                this.fireRemoved(element);
            }
        }
    }

    public void queryFinished(ISearchQuery query) {
        this.fireFinished(query);
    }

    public void queryStarting(ISearchQuery query) {
        this.fireStarting(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(ISearchQuery query) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            if (this.fQueries.contains(query)) {
                this.fQueries.remove(query);
                this.fQueries.add(0, query);
            }
        }
    }
}

