/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.editor.DSFormOutlinePage;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContext;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContextManager;
import org.eclipse.pde.internal.ds.ui.editor.DSOverviewPage;
import org.eclipse.pde.internal.ds.ui.editor.DSServicesPage;
import org.eclipse.pde.internal.ds.ui.editor.DSSourcePage;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class DSEditor
extends MultiSourceEditor {
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new DSOverviewPage((FormEditor)this));
            this.addPage((IFormPage)new DSServicesPage((FormEditor)this));
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
        this.addSourcePage("ds-context");
    }

    public void contributeToToolbar(IToolBarManager manager) {
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new DSFormOutlinePage((PDEFormEditor)this);
    }

    protected InputContextManager createInputContextManager() {
        return new DSInputContextManager((PDEFormEditor)this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new DSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new DSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, FileStoreEditorInput input) {
        try {
            IFileStore store = EFS.getStore((URI)input.getURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            contexts.putContext((IEditorInput)in, (InputContext)new DSInputContext((PDEFormEditor)this, (IEditorInput)in, true));
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
    }

    private void addDSBuilder(IFile file) {
        try {
            ICommand[] commands;
            IProject project = file.getProject();
            IProjectDescription description = project.getDescription();
            ICommand[] iCommandArray = commands = description.getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if (command.getBuilderName().equals("org.eclipse.pde.ds.core.builder")) {
                    return;
                }
                ++n2;
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            ICommand command = description.newCommand();
            command.setBuilderName("org.eclipse.pde.ds.core.builder");
            newCommands[newCommands.length - 1] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            Activator.logException(e, null, null);
        }
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    protected String getEditorID() {
        return "org.eclipse.pde.ui.dsEditor";
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("ds-context");
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.addDSBuilder(fileInput.getFile());
        }
        super.doSave(monitor);
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new DSSourcePage(editor, title, name);
    }
}

