/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.launching.debug.model.AntLineBreakpoint;
import org.eclipse.ant.internal.launching.debug.model.DebugModelMessages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntModelChangeEvent;
import org.eclipse.ant.internal.ui.model.IAntModelListener;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;

public class AntModelCore
implements IBreakpointsListener {
    private static AntModelCore inst;
    private final List<IAntModelListener> fModelChangeListeners = new ArrayList<IAntModelListener>();

    public static AntModelCore getDefault() {
        if (inst == null) {
            inst = new AntModelCore();
        }
        return inst;
    }

    private AntModelCore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntModelListener(IAntModelListener listener) {
        List<IAntModelListener> list = this.fModelChangeListeners;
        synchronized (list) {
            this.fModelChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntModelListener(IAntModelListener listener) {
        List<IAntModelListener> list = this.fModelChangeListeners;
        synchronized (list) {
            this.fModelChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void notifyAntModelListeners(AntModelChangeEvent event) {
        var3_2 = this.fModelChangeListeners;
        synchronized (var3_2) {
            i = new ArrayList<IAntModelListener>(this.fModelChangeListeners).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl11
        }
        do {
            i.next().antModelChanged(event);
lbl11:
            // 2 sources

        } while (i.hasNext());
    }

    private void updateBreakpointMessages(IBreakpoint[] breakpoints) {
        IWorkspaceRunnable runnable = monitor -> {
            IBreakpoint[] iBreakpointArray2 = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker;
                IBreakpoint breakpoint = iBreakpointArray2[n2];
                if (breakpoint instanceof AntLineBreakpoint && (marker = breakpoint.getMarker()).exists()) {
                    int lineNumber = marker.getAttribute("lineNumber", 0);
                    marker.setAttribute("message", (Object)MessageFormat.format(DebugModelMessages.AntLineBreakpoint_0, Integer.toString(lineNumber)));
                }
                ++n2;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.updateBreakpointMessages(breakpoints);
    }

    public void stopBreakpointListening() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
    }

    public void startBreakpointListening() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }
}

