/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.csv;

import java.util.Arrays;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.CommonWriterSettings;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldEnumSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldIndexSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldNameSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSet;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;

public class CsvWriterSettings
extends CommonWriterSettings<CsvFormat> {
    private boolean escapeUnquotedValues = false;
    private boolean quoteAllFields = false;
    private boolean isInputEscaped = false;
    private boolean normalizeLineEndingsWithinQuotes = true;
    private char[] quotationTriggers = new char[0];
    private boolean quoteEscapingEnabled = false;
    private boolean quoteNulls = true;
    private FieldSelector quotedFieldSelector = null;

    public boolean getQuoteAllFields() {
        return this.quoteAllFields;
    }

    public CsvWriterSettings setQuoteAllFields(boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
        return this;
    }

    public boolean isEscapeUnquotedValues() {
        return this.escapeUnquotedValues;
    }

    public CsvWriterSettings setEscapeUnquotedValues(boolean escapeUnquotedValues) {
        this.escapeUnquotedValues = escapeUnquotedValues;
        return this;
    }

    public final boolean isInputEscaped() {
        return this.isInputEscaped;
    }

    public final CsvWriterSettings setInputEscaped(boolean isInputEscaped) {
        this.isInputEscaped = isInputEscaped;
        return this;
    }

    public boolean isNormalizeLineEndingsWithinQuotes() {
        return this.normalizeLineEndingsWithinQuotes;
    }

    public CsvWriterSettings setNormalizeLineEndingsWithinQuotes(boolean normalizeLineEndingsWithinQuotes) {
        this.normalizeLineEndingsWithinQuotes = normalizeLineEndingsWithinQuotes;
        return this;
    }

    @Override
    protected CsvFormat createDefaultFormat() {
        return new CsvFormat();
    }

    public char[] getQuotationTriggers() {
        return this.quotationTriggers;
    }

    public CsvWriterSettings setQuotationTriggers(char ... quotationTriggers) {
        this.quotationTriggers = quotationTriggers == null ? new char[]{} : quotationTriggers;
        return this;
    }

    public boolean isQuotationTrigger(char ch) {
        for (int i = 0; i < this.quotationTriggers.length; ++i) {
            if (this.quotationTriggers[i] != ch) continue;
            return true;
        }
        return false;
    }

    public boolean isQuoteEscapingEnabled() {
        return this.quoteEscapingEnabled;
    }

    public CsvWriterSettings setQuoteEscapingEnabled(boolean quoteEscapingEnabled) {
        this.quoteEscapingEnabled = quoteEscapingEnabled;
        return this;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Quote all fields", this.quoteAllFields);
        out.put("Escape unquoted values", this.escapeUnquotedValues);
        out.put("Normalize escaped line separators", this.normalizeLineEndingsWithinQuotes);
        out.put("Input escaped", this.isInputEscaped);
        out.put("Quote escaping enabled", this.quoteEscapingEnabled);
        out.put("Quotation triggers", Arrays.toString(this.quotationTriggers));
    }

    @Override
    public final CsvWriterSettings clone() {
        return (CsvWriterSettings)super.clone();
    }

    @Override
    public final CsvWriterSettings clone(boolean clearInputSpecificSettings) {
        return (CsvWriterSettings)super.clone(clearInputSpecificSettings);
    }

    final FieldSelector getQuotedFieldSelector() {
        return this.quotedFieldSelector;
    }

    private <T> FieldSet<T> setFieldSet(FieldSet<T> fieldSet, T ... values) {
        this.quotedFieldSelector = (FieldSelector)((Object)fieldSet);
        fieldSet.add(values);
        return fieldSet;
    }

    public final FieldSet<Enum> quoteFields(Enum ... columns) {
        return this.setFieldSet(new FieldEnumSelector(), columns);
    }

    public final FieldSet<String> quoteFields(String ... columns) {
        return this.setFieldSet(new FieldNameSelector(), columns);
    }

    public final FieldSet<Integer> quoteIndexes(Integer ... columns) {
        return this.setFieldSet(new FieldIndexSelector(), columns);
    }

    public void setQuoteNulls(boolean quoteNulls) {
        this.quoteNulls = quoteNulls;
    }

    public boolean getQuoteNulls() {
        return this.quoteNulls;
    }
}

