/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources.impl;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.resources.impl.WSCaptureUtils;
import org.eclipse.rcptt.resources.impl.WSRunnables;
import org.eclipse.rcptt.verifications.resources.impl.WorkspaceVerificationChecker;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.eclipse.rcptt.workspace.WorkspaceVerification;

public class WorkspaceVerificationProcessor
extends VerificationProcessor {
    public Verification create(EObject param, IProcess process) throws CoreException {
        WorkspaceVerification verification = WorkspaceFactory.eINSTANCE.createWorkspaceVerification();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        WSCaptureUtils.capture((IWorkspace)ws, (WorkspaceData)verification);
        return verification;
    }

    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        final WorkspaceVerification wc = (WorkspaceVerification)verification;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(WSRunnables.refreshWorkspace, null, 1, null);
        ws.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                new WorkspaceVerificationChecker(wc).verifyWorkspace();
            }
        }, null, 1, null);
    }
}

