/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSyncCache;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;

public class GitLazyResourceVariantTreeSubscriber
extends GitResourceVariantTreeSubscriber {
    private boolean isLoaded;
    private boolean isValid;

    public GitLazyResourceVariantTreeSubscriber(GitSynchronizeDataSet gsds) {
        super(gsds);
    }

    @Override
    public boolean isSupervised(IResource res) throws TeamException {
        return true;
    }

    @Override
    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        if (this.getDataSet().shouldBeIncluded(local)) {
            return super.getSyncInfo(local, base, remote);
        }
        IProject project = local.getProject();
        Repository repo = ResourceUtil.getRepository(local);
        if (repo == null) {
            return null;
        }
        GitSynchronizeData data = this.getDataSet().getData(project);
        if (data == null) {
            for (GitSynchronizeData sd : this.getDataSet()) {
                if (!repo.equals(sd.getRepository())) continue;
                data = sd;
                break;
            }
        }
        if (data == null) {
            return null;
        }
        return this.getSyncInfo(local, base, remote, data);
    }

    private SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, @NonNull GitSynchronizeData gsd) {
        GitSyncObjectCache repoCache = this.getCache().get(gsd.getRepository());
        if (repoCache == null) {
            return null;
        }
        if (!this.isLoaded) {
            this.isLoaded = true;
            this.isValid = GitSyncCache.loadDataFromGit(gsd, null, repoCache);
        }
        if (this.isValid) {
            try {
                return this.getSyncInfo(local, base, remote, gsd.getRepository());
            }
            catch (TeamException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return CoreText.GitLazyResourceVariantTreeSubscriber_name;
    }

    @Override
    public IResource[] roots() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            for (GitSynchronizeData data : this.getDataSet()) {
                projects.addAll(Arrays.asList(ProjectUtil.getValidOpenProjects(data.getRepository())));
            }
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        return projects.toArray(new IResource[0]);
    }
}

