/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.model.AbstractRefactoringDescriptorResourceMapping;
import org.eclipse.ltk.core.refactoring.model.AbstractRefactoringHistoryResourceMapping;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.ui.refactoring.actions.AcceptRefactoringsAction;
import org.eclipse.ltk.internal.ui.refactoring.actions.RejectRefactoringsAction;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationActionProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RefactoringSynchronizationActionProvider
extends SynchronizationActionProvider {
    private static void getRefactoring(ISynchronizationScope scope, RefactoringDescriptorProxy proxy, Set<RefactoringDescriptorProxy> set) {
        AbstractRefactoringDescriptorResourceMapping extended;
        IResource resource;
        ResourceMapping mapping = (ResourceMapping)proxy.getAdapter(ResourceMapping.class);
        if (mapping instanceof AbstractRefactoringDescriptorResourceMapping && (resource = (extended = (AbstractRefactoringDescriptorResourceMapping)mapping).getResource()) != null && scope.contains(resource)) {
            set.add(proxy);
        }
    }

    private static RefactoringDescriptorProxy[] getRefactorings(ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        IStructuredSelection structured;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
        ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
            ISynchronizationScope scope = context.getScope();
            Object[] objectArray = structured.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof RefactoringHistory) {
                    RefactoringSynchronizationActionProvider.getRefactorings(scope, (RefactoringHistory)element, set);
                } else if (element instanceof RefactoringDescriptorProxy) {
                    RefactoringSynchronizationActionProvider.getRefactoring(scope, (RefactoringDescriptorProxy)element, set);
                } else if (element instanceof RefactoringDescriptor) {
                    RefactoringSynchronizationActionProvider.getRefactoring(scope, (RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)element), set);
                }
                ++n2;
            }
        }
        return set.toArray(new RefactoringDescriptorProxy[set.size()]);
    }

    private static void getRefactorings(ISynchronizationScope scope, RefactoringHistory history, Set<RefactoringDescriptorProxy> set) {
        AbstractRefactoringHistoryResourceMapping extended;
        IResource resource;
        ResourceMapping mapping = (ResourceMapping)history.getAdapter(ResourceMapping.class);
        if (mapping instanceof AbstractRefactoringHistoryResourceMapping && (resource = (extended = (AbstractRefactoringHistoryResourceMapping)mapping).getResource()) != null && scope.contains(resource)) {
            set.addAll(Arrays.asList(history.getDescriptors()));
        }
    }

    private static boolean hasRefactoring(ISynchronizationScope scope, RefactoringDescriptorProxy proxy) {
        AbstractRefactoringDescriptorResourceMapping extended;
        IResource resource;
        ResourceMapping mapping = (ResourceMapping)proxy.getAdapter(ResourceMapping.class);
        if (mapping instanceof AbstractRefactoringDescriptorResourceMapping && (resource = (extended = (AbstractRefactoringDescriptorResourceMapping)mapping).getResource()) != null) {
            return scope.contains(resource);
        }
        return false;
    }

    private static boolean hasRefactorings(ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        IStructuredSelection structured;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
            ISynchronizationScope scope = context.getScope();
            Object[] objectArray = structured.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof RefactoringHistory) {
                    return RefactoringSynchronizationActionProvider.hasRefactorings(scope, (RefactoringHistory)element);
                }
                if (element instanceof RefactoringDescriptorProxy) {
                    return RefactoringSynchronizationActionProvider.hasRefactoring(scope, (RefactoringDescriptorProxy)element);
                }
                if (element instanceof RefactoringDescriptor) {
                    return RefactoringSynchronizationActionProvider.hasRefactoring(scope, (RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)element));
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean hasRefactorings(ISynchronizationScope scope, RefactoringHistory history) {
        AbstractRefactoringHistoryResourceMapping extended;
        IResource resource;
        ResourceMapping mapping = (ResourceMapping)history.getAdapter(ResourceMapping.class);
        if (mapping instanceof AbstractRefactoringHistoryResourceMapping && (resource = (extended = (AbstractRefactoringHistoryResourceMapping)mapping).getResource()) != null) {
            return scope.contains(resource);
        }
        return false;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.isRefactoringElementSelected()) {
            ISynchronizationContext context = this.getSynchronizationContext();
            RefactoringDescriptorProxy[] proxies = RefactoringSynchronizationActionProvider.getRefactorings(context, this.getSynchronizePageConfiguration());
            AcceptRefactoringsAction accept = new AcceptRefactoringsAction(context, this.getExtensionSite().getViewSite().getShell());
            accept.setRefactoringDescriptors(proxies);
            menu.add((IAction)accept);
            RejectRefactoringsAction reject = new RejectRefactoringsAction(context);
            reject.setRefactoringDescriptors(proxies);
            menu.add((IAction)reject);
        }
    }

    protected void initialize() {
        super.initialize();
        ISynchronizePageConfiguration configuration = this.getSynchronizePageConfiguration();
        this.registerHandler("org.eclipse.team.ui.mergeAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.mergeAction", (ISynchronizePageConfiguration)configuration)));
        this.registerHandler("org.eclipse.team.ui.overwriteAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.overwriteAction", (ISynchronizePageConfiguration)configuration)));
        this.registerHandler("org.eclipse.team.ui.markAsMergeAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.markAsMergeAction", (ISynchronizePageConfiguration)configuration)));
    }

    protected void initializeOpenActions() {
        if (!RefactoringSynchronizationActionProvider.hasRefactorings(this.getSynchronizationContext(), this.getSynchronizePageConfiguration())) {
            super.initializeOpenActions();
        }
    }

    private boolean isRefactoringElementSelected() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection extended = (IStructuredSelection)selection;
            for (Object element : extended) {
                if (!(element instanceof RefactoringDescriptorProxy) && !(element instanceof RefactoringDescriptor) && !(element instanceof RefactoringHistory)) continue;
                return true;
            }
        }
        return false;
    }

    private final class RefactoringHandlerDelegate
    extends AbstractHandler {
        private final IHandler fDelegateHandler;

        public RefactoringHandlerDelegate(IHandler handler) {
            Assert.isNotNull((Object)handler);
            this.fDelegateHandler = handler;
        }

        public void dispose() {
            this.fDelegateHandler.dispose();
            super.dispose();
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            return this.fDelegateHandler.execute(event);
        }

        public boolean isEnabled() {
            return !RefactoringSynchronizationActionProvider.hasRefactorings(RefactoringSynchronizationActionProvider.this.getSynchronizationContext(), RefactoringSynchronizationActionProvider.this.getSynchronizePageConfiguration()) && this.fDelegateHandler.isEnabled();
        }
    }
}

