/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProductConfigurationSection {
    private static final String S_PRODUCT_CONFIG = "productConfig";
    private static final String S_PRODUCT_ROOT = "productRoot";
    private Text fProductRootText;
    private Combo fProductCombo;
    private final ProductExportWizardPage fPage;

    public ProductConfigurationSection(ProductExportWizardPage page) {
        this.fPage = page;
    }

    public Control createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.ProductExportWizardPage_productGroup);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductExportWizardPage_config);
        this.fProductCombo = new Combo((Composite)group, 2048);
        this.fProductCombo.setLayoutData((Object)new GridData(768));
        Button browse = new Button((Composite)group, 8);
        browse.setText(PDEUIMessages.ProductExportWizardPage_browse);
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleBrowse()));
        SWTUtil.setButtonDimensionHint(browse);
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductExportWizardPage_root);
        this.fProductRootText = new Text((Composite)group, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProductRootText.setLayoutData((Object)gd);
        return group;
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fPage.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ProductExportWizardPage_fileSelection);
        dialog.setMessage(PDEUIMessages.ProductExportWizardPage_productSelection);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("product"));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        IFile product = this.getProductFile();
        if (product != null) {
            dialog.setInitialSelection((Object)product);
        }
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.product_configuration_selection");
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            String value = file.getFullPath().toString();
            if (this.fProductCombo.indexOf(value) == -1) {
                this.fProductCombo.add(value, 0);
            }
            this.fProductCombo.setText(value);
        }
    }

    protected void hookListeners() {
        this.fProductCombo.addModifyListener(e -> {
            this.updateProductFields();
            this.fPage.pageChanged();
        });
    }

    protected void initialize(IStructuredSelection selection, IDialogSettings settings) {
        int i = 0;
        while (i < 6) {
            IFile file;
            String curr = settings.get(S_PRODUCT_CONFIG + String.valueOf(i));
            if (curr != null && this.fProductCombo.indexOf(curr) == -1 && (file = this.getProductFile(curr)).exists()) {
                this.fProductCombo.add(curr);
            }
            ++i;
        }
        if (!selection.isEmpty()) {
            Object object = selection.getFirstElement();
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                if ("product".equals(file.getFileExtension())) {
                    String entry = file.getFullPath().toString();
                    if (this.fProductCombo.indexOf(entry) == -1) {
                        this.fProductCombo.add(entry, 0);
                    }
                    this.fProductCombo.setText(entry);
                }
            } else if (object instanceof IContainer) {
                IContainer container = (IContainer)object;
                try {
                    if (container.isAccessible()) {
                        IResource[] resources;
                        IResource[] iResourceArray = resources = container.members();
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String path;
                            IResource resource = iResourceArray[n2];
                            if (resource instanceof IFile && resource.getName().endsWith(".product") && this.fProductCombo.indexOf(path = resource.getFullPath().toString()) == -1) {
                                this.fProductCombo.add(path, 0);
                            }
                            ++n2;
                        }
                    }
                    if (this.fProductCombo.getItemCount() > 0) {
                        this.fProductCombo.setText(this.fProductCombo.getItem(0));
                    }
                }
                catch (CoreException coreException) {}
            }
        } else if (this.fProductCombo.getItemCount() > 0) {
            this.fProductCombo.setText(this.fProductCombo.getItem(0));
        }
        this.setRoot(settings);
        this.hookListeners();
    }

    protected IFile getProductFile() {
        return this.getProductFile(this.fProductCombo.getText().trim());
    }

    protected IFile getProductFile(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IPath thePath = IPath.fromOSString((String)path);
        return thePath.segmentCount() < 2 ? null : PDEPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)path));
    }

    protected void updateProductFields() {
        IFile file = this.getProductFile();
        String root = null;
        try {
            if (file != null && file.exists()) {
                root = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_ROOT);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (root != null) {
            this.fProductRootText.setText(root);
        }
        this.fPage.updateProductFields();
    }

    protected void setRoot(IDialogSettings settings) {
        IFile file = this.getProductFile();
        String root = null;
        try {
            if (file != null && file.exists()) {
                root = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_ROOT);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (root == null) {
            root = settings.get(S_PRODUCT_CONFIG);
        }
        if (root == null) {
            root = "eclipse";
        }
        this.fProductRootText.setText(root);
    }

    protected String getRootDirectory() {
        return this.fProductRootText.getText().trim();
    }

    protected void saveSettings(IDialogSettings settings) {
        this.saveCombo(settings);
        settings.put(S_PRODUCT_ROOT, this.fProductRootText.getText().trim());
        IFile file = this.getProductFile();
        try {
            if (file != null && file.exists()) {
                file.setPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_ROOT, this.getRootDirectory());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void saveCombo(IDialogSettings settings) {
        if (this.fProductCombo.getText().trim().length() > 0) {
            settings.put(S_PRODUCT_CONFIG + String.valueOf(0), this.fProductCombo.getText().trim());
            String[] items = this.fProductCombo.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(S_PRODUCT_CONFIG + String.valueOf(i + 1), items[i].trim());
                ++i;
            }
        }
    }

    protected String validate() {
        String configLocation = this.fProductCombo.getText().trim();
        if (configLocation.length() == 0) {
            return PDEUIMessages.ProductExportWizardPage_noProduct;
        }
        IPath path = IPath.fromOSString((String)configLocation);
        IResource resource = PDEPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null || !(resource instanceof IFile)) {
            return PDEUIMessages.ProductExportWizardPage_productNotExists;
        }
        if (!resource.getName().endsWith(".product")) {
            return PDEUIMessages.ProductExportWizardPage_wrongExtension;
        }
        return null;
    }
}

