/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser;

import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.swt.graphics.ImageData;

public class ImageElement {
    private static final Pattern PLUGIN_PATTERN = Pattern.compile("([a-zA-Z0-9]+\\.[a-zA-Z0-9\\.]+)_.+");
    private SoftReference<ImageData> mImageData = new SoftReference<Object>(null);
    private final Callable<ImageData> mImageProvider;
    private final String mPlugin;
    private final String mPath;

    public ImageElement(Callable<ImageData> imageProvider, String plugin, String path) {
        this.mImageProvider = imageProvider;
        this.mPlugin = plugin;
        this.mPath = path;
    }

    public String getFullPlugin() {
        return this.mPlugin;
    }

    public String getPlugin() {
        Matcher matcher = PLUGIN_PATTERN.matcher(this.getFullPlugin());
        if (matcher.matches() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return this.getFullPlugin();
    }

    public String getPath() {
        return this.mPath;
    }

    public ImageData getImageData() {
        ImageData imageData = this.mImageData.get();
        if (imageData == null) {
            try {
                imageData = this.mImageProvider.call();
            }
            catch (Exception e) {
                PDECore.log((Throwable)e);
                imageData = ImageDescriptor.getMissingImageDescriptor().getImageData(100);
            }
            this.mImageData = new SoftReference<ImageData>(imageData);
        }
        return imageData;
    }

    public String getFileName() {
        return IPath.fromOSString((String)this.mPath).lastSegment();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
        result = 31 * result + (this.mPlugin == null ? 0 : this.mPlugin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageElement other = (ImageElement)obj;
        if (this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath)) {
            return false;
        }
        return !(this.mPlugin == null ? other.mPlugin != null : !this.mPlugin.equals(other.mPlugin));
    }
}

