/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.launcher.LaunchAction;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginConfigurationSection
extends TableSection {
    private TableViewer fConfigurationsTable;
    private TableEditor fLevelColumnEditor;
    private TableEditor fAutoColumnEditor;
    private static final Map<String, Integer> RECOMMENDED_AUTOSTART_BUNDLES = Map.of("org.apache.felix.scr", 2, "org.eclipse.core.runtime", 0, "org.eclipse.equinox.common", 2, "org.eclipse.equinox.event", 2, "org.eclipse.equinox.simpleconfigurator", 1);

    public PluginConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, PluginConfigurationSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_recommended, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll};
        return labels;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ConfigurationPageMock_sectionTitle);
        section.setDescription(PDEUIMessages.ConfigurationPageMock_sectionDesc);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 3, toolkit);
        this.createViewerPartControl(container, 65540, 3, toolkit);
        this.fConfigurationsTable = this.getTablePart().getTableViewer();
        Table table = this.fConfigurationsTable.getTable();
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(PDEUIMessages.PluginConfigurationSection_tablePluginTitle);
        column1.setWidth(300);
        TableColumn levelColumnEditor = new TableColumn(table, 16384);
        levelColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        TableColumn autoColumnEditor = new TableColumn(table, 16384);
        autoColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        table.addControlListener(ControlListener.controlResizedAdapter(e -> {
            int size = table.getSize().x;
            column1.setWidth(size / 7 * 4);
            levelColumnEditor.setWidth(size / 7 * 2);
            autoColumnEditor.setWidth(size / 7 * 1);
        }));
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        this.fConfigurationsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        IProduct product = this.getProduct();
        IStructuredContentProvider productConfigurationContent = i -> this.getProduct().getPluginConfigurations();
        this.fConfigurationsTable.setContentProvider((IContentProvider)productConfigurationContent);
        this.fConfigurationsTable.setInput((Object)product);
        this.createEditors();
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(true, true);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddDefaults();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    private void handleAdd() {
        IProduct product = this.getProduct();
        Set<String> configuredPlugins = this.getConfiguredPlugins(product);
        IPluginModelBase[] selectablePlugins = (IPluginModelBase[])LaunchAction.getAllLaunchedPlugins(product).filter(p -> !(p instanceof IFragmentModel) && !configuredPlugins.contains(p.getPluginBase().getId())).toArray(IPluginModelBase[]::new);
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), selectablePlugins, true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IPluginModelBase pluginModelBase = (IPluginModelBase)object;
                this.addPlugin(pluginModelBase.getPluginBase().getId());
                ++n2;
            }
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fConfigurationsTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            List configs = ssel.toList();
            this.getProduct().removePluginConfigurations((IPluginConfiguration[])configs.toArray(IPluginConfiguration[]::new));
        }
        this.clearEditors();
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePluginConfigurations(product.getPluginConfigurations());
        this.clearEditors();
    }

    private void handleAddDefaults() {
        IProduct product = this.getProduct();
        Set<String> configuredPluginIDs = this.getConfiguredPlugins(product);
        Set allPlugins = LaunchAction.getAllLaunchedPlugins(product).map(IPluginModelBase::getPluginBase).map(IIdentifiable::getId).collect(Collectors.toSet());
        StringBuilder bundlesList = new StringBuilder();
        RECOMMENDED_AUTOSTART_BUNDLES.forEach((pluginID, autoStartLevel) -> {
            if (!configuredPluginIDs.contains(pluginID) && allPlugins.contains(pluginID)) {
                bundlesList.append('\t');
                bundlesList.append((String)pluginID);
                bundlesList.append(", ");
                if (autoStartLevel > 0) {
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_levelColumn);
                    bundlesList.append(' ');
                    bundlesList.append(autoStartLevel);
                } else {
                    bundlesList.append(NLS.bind((String)PDEUIMessages.EquinoxPluginBlock_defaultLevelColumn, (Object)"Default"));
                }
                bundlesList.append('\n');
            }
        });
        if (!bundlesList.isEmpty()) {
            String message = NLS.bind((String)PDEUIMessages.Product_PluginSection_RecommendedBundles_message, (Object)bundlesList);
            if (MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)message)) {
                ArrayList pluginConfigs = new ArrayList();
                IProductModelFactory factory = product.getModel().getFactory();
                RECOMMENDED_AUTOSTART_BUNDLES.forEach((pluginID, autoStartLevel) -> {
                    IPluginConfiguration configuration = factory.createPluginConfiguration();
                    configuration.setId(pluginID);
                    if (autoStartLevel > 0) {
                        configuration.setStartLevel(autoStartLevel.intValue());
                    }
                    configuration.setAutoStart(true);
                    pluginConfigs.add(configuration);
                });
                product.addPluginConfigurations((IPluginConfiguration[])pluginConfigs.toArray(IPluginConfiguration[]::new));
                this.showControls();
            }
        } else {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)PDEUIMessages.Product_PluginSection_NoRecommendedBundles_message);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.updateRemoveButtons(true, false);
    }

    private Set<String> getConfiguredPlugins(IProduct product) {
        IPluginConfiguration[] configurations = product.getPluginConfigurations();
        return Arrays.stream(configurations).map(IPluginConfiguration::getId).collect(Collectors.toSet());
    }

    private void addPlugin(String id) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IPluginConfiguration configuration = factory.createPluginConfiguration();
        configuration.setId(id);
        product.addPluginConfigurations(new IPluginConfiguration[]{configuration});
        this.fConfigurationsTable.setSelection((ISelection)new StructuredSelection((Object)configuration));
        this.showControls();
    }

    private void clearEditors() {
        Control oldEditor = this.fLevelColumnEditor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
        if ((oldEditor = this.fAutoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void createEditors() {
        Table table = this.fConfigurationsTable.getTable();
        this.fLevelColumnEditor = new TableEditor(table);
        this.fLevelColumnEditor.horizontalAlignment = 0x1000000;
        this.fLevelColumnEditor.minimumWidth = 40;
        this.fLevelColumnEditor.grabHorizontal = true;
        if (Util.isMac()) {
            this.fLevelColumnEditor.minimumHeight = 27;
        }
        this.fAutoColumnEditor = new TableEditor(table);
        this.fAutoColumnEditor.horizontalAlignment = 0x1000000;
        this.fAutoColumnEditor.grabHorizontal = true;
        this.fAutoColumnEditor.minimumWidth = 50;
        table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showControls()));
    }

    private void showControls() {
        this.clearEditors();
        Table table = this.fConfigurationsTable.getTable();
        IStructuredSelection selection = this.fConfigurationsTable.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        TableItem item = table.getSelection()[0];
        if (item != null && !this.isEditable()) {
            return;
        }
        if (item != null) {
            IPluginConfiguration ppc = (IPluginConfiguration)selection.getFirstElement();
            Spinner spinner = new Spinner((Composite)table, 2048);
            spinner.setMinimum(0);
            String level = item.getText(1);
            int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
            spinner.setSelection(defaultLevel);
            spinner.addModifyListener(e -> {
                int selection1 = spinner.getSelection();
                item.setText(1, selection1 == 0 ? "default" : Integer.toString(selection1));
                ppc.setStartLevel(selection1);
            });
            this.fLevelColumnEditor.setEditor((Control)spinner, item, 1);
            CCombo combo = new CCombo((Composite)table, 2056);
            combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
            combo.setText(item.getText(2));
            combo.pack();
            combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                item.setText(2, combo.getText());
                ppc.setAutoStart(Boolean.parseBoolean(combo.getText()));
            }));
            this.fAutoColumnEditor.setEditor((Control)combo, item, 2);
        }
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleGlobalRefresh();
            return;
        }
        Table table = this.fConfigurationsTable.getTable();
        boolean refreshRemove = false;
        boolean refreshRemoveAll = false;
        if (e.getChangeType() == 1) {
            if (table.getItemCount() == 0) {
                refreshRemoveAll = true;
            }
            Object[] objectArray = e.getChangedObjects();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.add(object);
                }
                ++n2;
            }
        } else if (e.getChangeType() == 2) {
            int count;
            refreshRemoveAll = true;
            refreshRemove = true;
            boolean global = false;
            Object[] objectArray = e.getChangedObjects();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.remove(object);
                } else if (object instanceof IProductPlugin) {
                    global = true;
                    break;
                }
                ++n3;
            }
            if (global) {
                this.handleGlobalRefresh();
            }
            if ((count = table.getItemCount()) == 0) {
                table.deselectAll();
                this.clearEditors();
            } else {
                int index = table.getSelectionIndex();
                table.setSelection(Math.min(index, count - 1));
            }
        }
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(refreshRemove, refreshRemoveAll);
    }

    private void handleGlobalRefresh() {
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.fConfigurationsTable.refresh();
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        if (updateRemove) {
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(2, this.isEditable() && !selection.isEmpty());
        }
        int count = this.fConfigurationsTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(3, this.isEditable() && count > 0);
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return super.getColumnImage(PluginRegistry.findModel((String)((IPluginConfiguration)obj).getId()), index);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IPluginConfiguration configuration = (IPluginConfiguration)obj;
            return switch (index) {
                case 0 -> configuration.getId();
                case 1 -> {
                    int startLevel = configuration.getStartLevel();
                    if (startLevel == 0) {
                        yield "default";
                    }
                    yield Integer.toString(startLevel);
                }
                case 2 -> Boolean.toString(configuration.isAutoStart());
                default -> null;
            };
        }
    }
}

