/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.ecl.model.GetPropertyNodes;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.ui.panels.assertion.AssertGroup;
import org.eclipse.rcptt.ui.panels.assertion.AssertInput;
import org.eclipse.rcptt.ui.panels.assertion.AssertionUtils;

public class AssertContentProvider
implements ITreeContentProvider {
    private final AutLaunch launch;
    private AssertInput input;

    public AssertContentProvider(AutLaunch launch) {
        this.launch = launch;
    }

    public Object[] getElements(Object inputElement) {
        List<AssertGroup> asserts = ((AssertInput)inputElement).getAsserts();
        ArrayList<AssertGroup> result = new ArrayList<AssertGroup>();
        for (AssertGroup assertGroup : asserts) {
            if (assertGroup.getAsserts().isEmpty()) continue;
            result.add(assertGroup);
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        return this.input.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return element instanceof AssertGroup;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AssertGroup) {
            AssertGroup parentGroup = (AssertGroup)parentElement;
            Object[] children = parentGroup.getAsserts().toArray(new Object[0]);
            if (children.length == 1 && children[0] instanceof AssertionUtils.ReferencePlaceholder) {
                Element element = ((AssertionUtils.ReferencePlaceholder)children[0]).getElement();
                return this.fetchChildren(parentGroup, element);
            }
            return children;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = (AssertInput)newInput;
    }

    public void dispose() {
    }

    private Object[] fetchChildren(AssertGroup assertGroup, Element element) {
        String path = this.buildPath(assertGroup);
        AssertionUtils.fillAdvancedPropertiesGroup(assertGroup.getAsserts(), (EList<PropertyNode>)this.loadChildren(element, path).getPropertyNodes(), element, path);
        this.input.reindex();
        return assertGroup.getAsserts().toArray();
    }

    public PropertyNodeList loadChildren(Element element, String path) {
        GetPropertyNodes getNodes = TeslaFactory.eINSTANCE.createGetPropertyNodes();
        getNodes.setElement((Element)EcoreUtil.copy((EObject)element));
        getNodes.setNodePath(path);
        Object result = null;
        try {
            result = this.launch.execute((Command)getNodes);
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
        if (result instanceof PropertyNodeList) {
            return (PropertyNodeList)result;
        }
        return UiFactory.eINSTANCE.createPropertyNodeList();
    }

    private String buildPath(AssertGroup assertGroup) {
        Object path = assertGroup.getName();
        Object parent = this.getParent(assertGroup);
        while (parent != null) {
            String parentName = null;
            if (parent instanceof AssertGroup) {
                parentName = ((AssertGroup)parent).getName();
            }
            if ((parent = this.getParent(parent)) == null || parentName == null) continue;
            path = parentName + "." + (String)path;
        }
        return path;
    }
}

