/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.context;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.ContextUIManager;
import org.eclipse.rcptt.ui.context.ContextViewer;
import org.eclipse.rcptt.ui.editors.CompositeNamedElementActions;
import org.eclipse.rcptt.ui.editors.IQ7Viewer2;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.context.ContextEditorPage;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.WorkbenchPart;

public class ContextEditor
extends NamedElementEditor {
    private ContextEditorPage page;
    private IEditorPart part;
    private ContextType type;
    NamedElementEditorActions.INamedElementActions ctxActions;

    public void setSelectionAtLine(int line) {
        if (this.page != null) {
            this.page.setSelectionAtLine(line);
        }
    }

    public Context getElement() {
        return (Context)super.getElement();
    }

    protected void addPages() {
        ContextViewer viewer = ContextUIManager.getInstance().getViewer(this.type);
        if (viewer != null && viewer.getViewer() instanceof IQ7Viewer2) {
            IQ7Viewer2 v2 = (IQ7Viewer2)viewer.getViewer();
            this.part = v2.createEditorPart();
            this.part.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (260 == propId) {
                        ContextEditor.this.setPartName(((WorkbenchPart)ContextEditor.this.part).getPartName());
                    }
                }
            });
            try {
                this.addPage(this.part, this.getEditorInput());
                this.setTitleImage(viewer.getIcon().createImage());
                this.setPartName(this.part.getTitle());
            }
            catch (PartInitException e) {
                Q7UIPlugin.log(e);
            }
            return;
        }
        try {
            this.page = new ContextEditorPage(this);
            this.addPage((IFormPage)this.page);
        }
        catch (PartInitException e) {
            Q7UIPlugin.log(e);
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.part instanceof EclEditor) {
            return this.part.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void setFocus() {
        super.setFocus();
        if (this.page != null) {
            this.page.setFocus();
        }
        if (this.part != null) {
            this.part.setFocus();
        }
    }

    protected IFile getInputFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            IFile inputFile = this.getInputFile(input);
            if (inputFile == null) {
                throw new PartInitException(Messages.NamedElementEditor_InvalidInputType);
            }
            IQ7NamedElement iq7Element = (IQ7NamedElement)RcpttCore.create((IResource)inputFile);
            this.type = ContextTypeManager.getInstance().getTypeByContext((Context)iq7Element.getNamedElement());
            if (this.type == null) {
                throw new PartInitException(Messages.bind((String)Messages.ContextEditor_EmptyContextType, (Object)this.getElement()));
            }
            ContextViewer viewer = ContextUIManager.getInstance().getViewer(this.type);
            if (viewer != null && viewer.getViewer() instanceof IQ7Viewer2) {
                IQ7Viewer2 v2 = (IQ7Viewer2)viewer.getViewer();
                this.setEnableResourceTracking(v2.isEnableResourceTracking());
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        super.init(site, input);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.page != null) {
                this.page.save();
            }
            if (this.part != null) {
                this.part.doSave(monitor);
            } else {
                super.doSave(monitor);
            }
            assert (!this.isDirty());
        }
        catch (CoreException e) {
            Q7UIPlugin.log(e);
        }
    }

    public void setEditorImage(Image img) {
        this.setTitleImage(img);
    }

    protected void createPages() {
        super.createPages();
        this.hideTabs();
    }

    @Override
    public void createActions() {
        CompositeNamedElementActions compositeActions = new CompositeNamedElementActions(new NamedElementEditorActions.INamedElementActions[]{this.page.getContent(), this.ctxActions}){

            @Override
            public void update() {
                ContextEditor.this.updateEnablement();
            }
        };
        this.actions = new NamedElementEditorActions(compositeActions, this.getEditorSite().getActionBars());
    }

    public IEditorPart getEditor() {
        return this.part;
    }

    public void setCtxActions(NamedElementEditorActions.INamedElementActions createActions) {
        this.ctxActions = createActions;
    }
}

