/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IMacBundleUrlType;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductObject;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LauncherInfo
extends ProductObject
implements ILauncherInfo {
    private static final long serialVersionUID = 1L;
    private boolean fUseIcoFile;
    private final Map<String, String> fIcons = new HashMap<String, String>();
    private String fLauncherName;
    private final TreeMap<String, IMacBundleUrlType> fMacBundleUrlTypes = new TreeMap();

    public LauncherInfo(IProductModel model) {
        super(model);
    }

    @Override
    public String getLauncherName() {
        return this.fLauncherName;
    }

    @Override
    public void setLauncherName(String name) {
        String old = this.fLauncherName;
        this.fLauncherName = name;
        if (this.isEditable()) {
            this.firePropertyChanged("launcher", old, this.fLauncherName);
        }
    }

    @Override
    public void setIconPath(String iconId, String path) {
        if (path == null) {
            path = "";
        }
        String old = this.fIcons.get(iconId);
        this.fIcons.put(iconId, path);
        if (this.isEditable()) {
            this.firePropertyChanged(iconId, old, path);
        }
    }

    @Override
    public String getIconPath(String iconId) {
        return this.fIcons.get(iconId);
    }

    @Override
    public boolean usesWinIcoFile() {
        return this.fUseIcoFile;
    }

    @Override
    public void setUseWinIcoFile(boolean use) {
        boolean old = this.fUseIcoFile;
        this.fUseIcoFile = use;
        if (this.isEditable()) {
            this.firePropertyChanged("useIco", Boolean.toString(old), Boolean.toString(this.fUseIcoFile));
        }
    }

    @Override
    public void parse(Node node) {
        block14: {
            if (node.getNodeType() != 1) break block14;
            this.fLauncherName = ((Element)node).getAttribute("name");
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                block15: {
                    String name;
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) break block15;
                    switch (name = child.getNodeName()) {
                        case "linux": {
                            this.parseLinux((Element)child);
                            break;
                        }
                        case "macosx": {
                            this.parseMac((Element)child);
                            break;
                        }
                        case "win": {
                            this.parseWin((Element)child);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void parseWin(Element element) {
        this.fUseIcoFile = "true".equals(element.getAttribute("useIco"));
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                Element child = (Element)children.item(i);
                String name = child.getNodeName();
                if (name.equals("ico")) {
                    this.fIcons.put("icoFile", child.getAttribute("path"));
                } else if (name.equals("bmp")) {
                    this.fIcons.put("winSmallHigh", child.getAttribute("winSmallHigh"));
                    this.fIcons.put("winSmallLow", child.getAttribute("winSmallLow"));
                    this.fIcons.put("winMediumHigh", child.getAttribute("winMediumHigh"));
                    this.fIcons.put("winMediumLow", child.getAttribute("winMediumLow"));
                    this.fIcons.put("winLargeHigh", child.getAttribute("winLargeHigh"));
                    this.fIcons.put("winLargeLow", child.getAttribute("winLargeLow"));
                    this.fIcons.put("winExtraLargeHigh", child.getAttribute("winExtraLargeHigh"));
                }
            }
            ++i;
        }
    }

    private void parseMac(Element element) {
        this.fIcons.put("macosxIcon", element.getAttribute("icon"));
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child;
            String name;
            if (children.item(i).getNodeType() == 1 && (name = (child = children.item(i)).getNodeName()).equals("bundleUrlTypes")) {
                NodeList grandChildren = child.getChildNodes();
                int j = 0;
                while (j < grandChildren.getLength()) {
                    Node grandChild = grandChildren.item(j);
                    if (grandChild.getNodeType() == 1 && grandChild.getNodeName().equals("bundleUrlType")) {
                        IMacBundleUrlType bundleUrlType = this.getModel().getFactory().createMacBundleUrlType();
                        bundleUrlType.parse(grandChild);
                        this.fMacBundleUrlTypes.put(bundleUrlType.getScheme(), bundleUrlType);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void parseLinux(Element element) {
        this.fIcons.put("linuxIcon", element.getAttribute("icon"));
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent + "<launcher");
        if (this.fLauncherName != null && this.fLauncherName.length() > 0) {
            writer.print(" name=\"" + this.fLauncherName + "\"");
        }
        writer.println(">");
        this.writeLinux(indent + "   ", writer);
        this.writeMac(indent + "   ", writer);
        this.writerWin(indent + "   ", writer);
        writer.println(indent + "</launcher>");
    }

    private void writerWin(String indent, PrintWriter writer) {
        writer.println(indent + "<win useIco=\"" + this.fUseIcoFile + "\">");
        String path = this.fIcons.get("icoFile");
        if (path != null && path.length() > 0) {
            writer.println(indent + "   <ico path=\"" + this.getWritableString(path) + "\"/>");
        }
        writer.print(indent + "   <bmp");
        this.writeIcon(indent + "   ", "winSmallHigh", writer);
        this.writeIcon(indent + "   ", "winSmallLow", writer);
        this.writeIcon(indent + "   ", "winMediumHigh", writer);
        this.writeIcon(indent + "   ", "winMediumLow", writer);
        this.writeIcon(indent + "   ", "winLargeHigh", writer);
        this.writeIcon(indent + "   ", "winLargeLow", writer);
        this.writeIcon(indent + "   ", "winExtraLargeHigh", writer);
        writer.println("/>");
        writer.println(indent + "</win>");
    }

    private void writeIcon(String indent, String iconId, PrintWriter writer) {
        String icon = this.fIcons.get(iconId);
        if (icon != null && icon.length() > 0) {
            writer.println();
            writer.print(indent + "   " + iconId + "=\"" + this.getWritableString(icon) + "\"");
        }
    }

    private void writeMac(String indent, PrintWriter writer) {
        String icon = this.fIcons.get("macosxIcon");
        if (icon != null && icon.length() > 0 || !this.fMacBundleUrlTypes.isEmpty()) {
            writer.print(indent + "<macosx");
            if (icon != null && icon.length() > 0) {
                writer.print(" icon=\"" + this.getWritableString(icon) + "\"");
            }
            if (this.fMacBundleUrlTypes.isEmpty()) {
                writer.println("/>");
            } else {
                writer.println(">");
                writer.println(indent + "   <bundleUrlTypes>");
                for (IMacBundleUrlType bundleUrlType : this.fMacBundleUrlTypes.values()) {
                    bundleUrlType.write(indent + "      ", writer);
                }
                writer.println(indent + "   </bundleUrlTypes>");
                writer.println(indent + "</macosx>");
            }
        }
    }

    private void writeLinux(String indent, PrintWriter writer) {
        String icon = this.fIcons.get("linuxIcon");
        if (icon != null && icon.length() > 0) {
            writer.println(indent + "<linux icon=\"" + this.getWritableString(icon) + "\"/>");
        }
    }

    @Override
    public List<IMacBundleUrlType> getMacBundleUrlTypes() {
        return List.copyOf(this.fMacBundleUrlTypes.values());
    }

    @Override
    public void addMacBundleUrlTypes(List<IMacBundleUrlType> bundleUrlTypes) {
        IProductObject[] addedUrlSchemes = (IMacBundleUrlType[])bundleUrlTypes.stream().map(urlType -> {
            String scheme;
            if (urlType != null && (scheme = urlType.getScheme()) != null && !this.fMacBundleUrlTypes.containsKey(scheme)) {
                urlType.setModel(this.getModel());
                this.fMacBundleUrlTypes.put(scheme, (IMacBundleUrlType)urlType);
                return urlType;
            }
            return null;
        }).filter(Objects::nonNull).toArray(IMacBundleUrlType[]::new);
        if (addedUrlSchemes.length > 0 && this.isEditable()) {
            this.fireStructureChanged(addedUrlSchemes, 1);
        }
    }

    @Override
    public void removeMacBundleUrlTypes(List<IMacBundleUrlType> bundleUrlTypes) {
        IProductObject[] removedUrlSchemes = (IProductObject[])bundleUrlTypes.stream().map(IMacBundleUrlType::getScheme).map(this.fMacBundleUrlTypes::remove).filter(Objects::nonNull).toArray(IProductObject[]::new);
        if (removedUrlSchemes.length > 0 && this.isEditable()) {
            this.fireStructureChanged(removedUrlSchemes, 2);
        }
    }
}

