/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class FeatureRebuilder
implements IFeatureModelListener,
IPluginModelListener,
IResourceChangeListener {
    private volatile boolean fTouchFeatures;

    public void start() {
        PDECore.getDefault().getFeatureModelManager().addFeatureModelListener(this);
        PDECore.getDefault().getModelManager().addPluginModelListener(this);
        JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)this, (int)8);
    }

    public void stop() {
        Job.getJobManager().cancel(FeatureRebuilder.class);
        PDECore.getDefault().getFeatureModelManager().removeFeatureModelListener(this);
        PDECore.getDefault().getModelManager().removePluginModelListener(this);
        JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this);
    }

    @Override
    public void modelsChanged(IFeatureModelDelta delta) {
        if ((1 & delta.getKind()) != 0 || (2 & delta.getKind()) != 0) {
            this.fTouchFeatures = true;
        }
    }

    @Override
    public void modelsChanged(PluginModelDelta delta) {
        if ((1 & delta.getKind()) != 0 || (2 & delta.getKind()) != 0) {
            this.fTouchFeatures = true;
        } else {
            ModelEntry[] changed = delta.getChangedEntries();
            if (changed.length > 0 && !changed[0].hasWorkspaceModels()) {
                this.touchFeatures();
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 8 && this.fTouchFeatures) {
            this.touchFeatures();
        }
    }

    private void touchFeatures() {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        final IFeatureModel[] workspaceFeatures = manager.getWorkspaceModels();
        if (workspaceFeatures.length > 0) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                WorkspaceJob job = new WorkspaceJob("Touching Features"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceFeatures.length);
                        FeatureRebuilder.this.touch(workspaceFeatures, subMonitor);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return FeatureRebuilder.class == family;
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.setRule(this.getTouchRule(workspaceFeatures));
                job.schedule();
            } else {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceFeatures.length);
                this.touch(workspaceFeatures, subMonitor);
            }
        } else {
            this.fTouchFeatures = false;
        }
    }

    private ISchedulingRule getTouchRule(IFeatureModel[] workspaceFeatures) {
        ArrayList<IResource> nestedRules = new ArrayList<IResource>(workspaceFeatures.length);
        int i = 0;
        while (i < workspaceFeatures.length) {
            nestedRules.add(workspaceFeatures[i].getUnderlyingResource());
            ++i;
        }
        if (nestedRules.size() == 1) {
            return (ISchedulingRule)nestedRules.get(0);
        }
        return MultiRule.combine((ISchedulingRule[])((ISchedulingRule[])nestedRules.toArray(new IResource[nestedRules.size()])));
    }

    private void touch(IFeatureModel[] workspaceFeatures, SubMonitor subMonitor) {
        IFeatureModel[] iFeatureModelArray = workspaceFeatures;
        int n = workspaceFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel feature = iFeatureModelArray[n2];
            if (subMonitor.isCanceled()) {
                return;
            }
            SubMonitor iterationMonitor = subMonitor.split(1);
            try {
                IResource resource = feature.getUnderlyingResource();
                if (resource != null && resource.isAccessible()) {
                    resource.touch((IProgressMonitor)iterationMonitor);
                }
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
            ++n2;
        }
        this.fTouchFeatures = false;
    }
}

