/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.reflection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeType;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;

public class EMFMembersHelper {
    public static final String LIST_SIZE_PROPERTY_CAPTION = "size";

    public static String getPropertyValue(Object object, String nodePath) {
        Object node = EMFMembersHelper.findNodeValue(object, nodePath);
        if (node != null) {
            return node.toString();
        }
        return null;
    }

    public static boolean fillProperties(Object object, String nodePath, EList<PropertyNode> propertiesNodes) {
        Object node = EMFMembersHelper.findNodeValue(object, nodePath);
        if (node != null) {
            EMFMembersHelper.fillProperties(node, propertiesNodes);
            return true;
        }
        return false;
    }

    public static void fillProperties(Object object, EList<PropertyNode> propertiesNodes) {
        EMFMembersHelper.fillProperties(object, propertiesNodes, "");
    }

    public static void fillProperties(Object object, EList<PropertyNode> propertiesNodes, String ... ignoresArray) {
        HashSet<String> ignores = new HashSet<String>(Arrays.asList(ignoresArray));
        if (object instanceof List) {
            EMFMembersHelper.processList(object, propertiesNodes);
        }
        if (object instanceof EObject) {
            EObject emfObject = (EObject)object;
            EClass eClass = emfObject.eClass();
            EList features = eClass.getEAllStructuralFeatures();
            for (EStructuralFeature eStructuralFeature : features) {
                if (ignores.contains(eStructuralFeature.getName())) continue;
                EMFMembersHelper.processStructuralFeature(emfObject, eStructuralFeature, propertiesNodes);
            }
        }
    }

    private static void processList(Object object, EList<PropertyNode> propertiesNodes) {
        List list = (List)object;
        PropertyNode lenghtNode = UiFactory.eINSTANCE.createPropertyNode();
        lenghtNode.setName(LIST_SIZE_PROPERTY_CAPTION);
        lenghtNode.setType(PropertyNodeType.PROPERTY);
        lenghtNode.setValue(Integer.toString(list.size()));
        propertiesNodes.add((Object)lenghtNode);
        int idx = 0;
        for (Object item : list) {
            if (item instanceof EObject) {
                EObject itemEmfObject = (EObject)item;
                EClass eClass = itemEmfObject.eClass();
                PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
                propertyNode.setName(eClass.getName() + "[" + idx + "]");
                propertyNode.setType(PropertyNodeType.REFERENCE);
                propertiesNodes.add((Object)propertyNode);
            } else {
                PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
                propertyNode.setName(item.getClass().getName());
                propertyNode.setType(PropertyNodeType.PROPERTY);
                String stringValue = SWTModelMapper.unify(item == null ? "" : item.toString());
                propertyNode.setValue(stringValue);
                propertiesNodes.add((Object)propertyNode);
            }
            ++idx;
        }
    }

    private static void processStructuralFeature(EObject emfObject, EStructuralFeature eStructuralFeature, EList<PropertyNode> propertiesNodes) {
        Object value = emfObject.eGet(eStructuralFeature);
        if (!(value instanceof EObject) && eStructuralFeature instanceof EAttribute) {
            PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
            propertyNode.setName(eStructuralFeature.getName());
            propertyNode.setType(PropertyNodeType.PROPERTY);
            String stringValue = SWTModelMapper.unify(value == null ? "" : value.toString());
            propertyNode.setValue(stringValue);
            propertiesNodes.add((Object)propertyNode);
        } else if (!eStructuralFeature.isMany() || eStructuralFeature.isMany() && value instanceof List) {
            PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
            propertyNode.setName(eStructuralFeature.getName());
            if (value != null) {
                propertyNode.setType(PropertyNodeType.REFERENCE);
            } else {
                propertyNode.setType(PropertyNodeType.PROPERTY);
                propertyNode.setValue("null");
            }
            propertiesNodes.add((Object)propertyNode);
        }
    }

    private static Object findNodeValue(Object object, String nodePath) {
        if (nodePath.matches(".*\\[(\\w+):(\\d+)\\].*")) {
            nodePath = nodePath.replaceAll("\\[(\\w+):(\\d+)\\]", ".$1[$2]");
        }
        String[] nodes = nodePath.split("\\.");
        Object current = object;
        String[] stringArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            if ((current = EMFMembersHelper.getNodeValue(current, node)) == null) {
                return null;
            }
            ++n2;
        }
        return current;
    }

    static Object getNodeValue(Object object, String node) {
        EObject emfObject;
        EClass eClass;
        EStructuralFeature feature;
        if (object instanceof List) {
            List list = (List)object;
            if (LIST_SIZE_PROPERTY_CAPTION.equals(node)) {
                return list.size();
            }
            if (node.matches(".*\\[.*\\]")) {
                String strIdx = node.substring(node.indexOf(91) + 1, node.indexOf(93));
                strIdx = strIdx.replaceAll("\\D", "");
                int idx = Integer.parseInt(strIdx);
                return list.get(idx);
            }
        }
        if (object instanceof EObject && (feature = (eClass = (emfObject = (EObject)object).eClass()).getEStructuralFeature(node)) != null) {
            Class class_;
            Object value = emfObject.eGet(feature);
            if (value == null && (class_ = feature.getEType().getInstanceClass()) == String.class) {
                value = "";
            }
            return value;
        }
        return null;
    }
}

