/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.handlers;

import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.CapabilityContext;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ctx.capability.CapabilityManager;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;

public class ContextConvertHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        try {
            IQ7Folder folder;
            IFile element = (IFile)selection.getFirstElement();
            IPath resourcePath = element.getFullPath();
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(shell);
            IQ7Project create = RcpttCore.create((IProject)element.getProject());
            IPath path = resourcePath.removeFirstSegments(1).removeLastSegments(1);
            IQ7Folder iQ7Folder = folder = path.segmentCount() >= 1 ? create.getFolder(path) : create.getFolders()[0];
            if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{folder})) {
                return null;
            }
            IContext context = folder.getContext(element.getName());
            NewCapabilityContextDialog dialog = new NewCapabilityContextDialog(shell, folder.getQ7Project());
            if (dialog.open() != 0) return null;
            IContext capability = folder.createContext(dialog.getName(), ContextTypeManager.getInstance().getTypeById("org.eclipse.rcptt.ctx.capability"), true, (IProgressMonitor)new NullProgressMonitor());
            IQ7NamedElement capabilityCopy = capability.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IQ7NamedElement copy = context.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                String id1 = capabilityCopy.getID();
                String id2 = copy.getID();
                copy.setID(id1);
                capabilityCopy.setID(id2);
                CapabilityContext capabilityCtx = (CapabilityContext)capabilityCopy.getNamedElement();
                CapabilityManager.getManager().addCapability(capabilityCtx, dialog.getCapabilities()).getContextReferences().add((Object)id1);
                if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{capabilityCopy})) {
                    Boolean bl = false;
                    return bl;
                }
                if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{copy})) {
                    Boolean bl = false;
                    return bl;
                }
                capabilityCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                return null;
            }
            finally {
                copy.discardWorkingCopy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class NewCapabilityContextDialog
    extends TitleAreaDialog {
        private final IQ7Project project;
        private String name;
        private String[] selected;

        public NewCapabilityContextDialog(Shell shell, IQ7Project project) {
            super(shell);
            this.project = project;
            this.setTitle("Create capability context.");
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Create capability context");
        }

        protected Point getInitialSize() {
            return new Point(300, 400);
        }

        public String getName() {
            return this.name;
        }

        public String[] getCapabilities() {
            return this.selected;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(control, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            Label label = new Label(composite, 16384);
            label.setText("Name:");
            final Text text = new Text(composite, 2048);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    name = text.getText();
                    this.validate();
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)label);
            GridDataFactory.fillDefaults().align(4, 1).grab(false, false).applyTo((Control)text);
            final CheckboxTableViewer listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            listViewer.setInput((Object)CapabilityManager.getManager().getAllCapabilities());
            listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object[] array = listViewer.getCheckedElements();
                    selected = (String[])Arrays.copyOf(array, array.length, String[].class);
                    this.validate();
                }
            });
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(listViewer.getControl());
            return control;
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.validate();
            return result;
        }

        protected void validate() {
            boolean valid = this.doValidate();
            if (valid) {
                this.setErrorMessage(null);
                this.setMessage("Create capability context:");
            }
        }

        protected boolean doValidate() {
            IQ7NamedElement[] elements;
            if (this.name == null || !Path.EMPTY.isValidSegment(this.name)) {
                this.setErrorMessage("Context name must be specified");
                return false;
            }
            IQ7NamedElement[] iQ7NamedElementArray = elements = Q7SearchCore.findByName((String)this.name, (ISearchScope)new ReferencedProjectScope(this.project), (IProgressMonitor)new NullProgressMonitor());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                if (iq7NamedElement instanceof IContext) {
                    this.setErrorMessage("Context with this name already exists.");
                    return false;
                }
                ++n2;
            }
            if (this.selected == null || this.selected.length == 0) {
                this.setErrorMessage("Context has to contain at least one capability value.");
                return false;
            }
            return true;
        }
    }
}

