/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.BundleValidationOperation;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;

public class LaunchValidationOperation
implements IWorkspaceRunnable {
    private BundleValidationOperation fOperation;
    public final ILaunchConfiguration fLaunchConfiguration;
    public final String fLaunchMode;
    protected final Set<IPluginModelBase> fModels;

    public LaunchValidationOperation(ILaunchConfiguration configuration, Set<IPluginModelBase> models) {
        this(configuration, models, null);
    }

    public LaunchValidationOperation(ILaunchConfiguration configuration, Set<IPluginModelBase> models, String launchMode) {
        this.fLaunchConfiguration = configuration;
        this.fModels = models;
        this.fLaunchMode = launchMode;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.fOperation = new BundleValidationOperation(this.fModels, (Dictionary[])this.getPlatformProperties());
        this.fOperation.run(monitor);
    }

    protected Dictionary<String, String>[] getPlatformProperties() throws CoreException {
        IExecutionEnvironment[] envs = this.getMatchingEnvironments();
        Dictionary environmentProperties = TargetPlatformHelper.getTargetEnvironment();
        int i = envs.length - 1;
        while (i > 0) {
            IExecutionEnvironment env = envs[i];
            Properties profileProps = this.getJavaProfileProperties(env.getId());
            if (profileProps == null) {
                profileProps = env.getProfileProperties();
            }
            if (profileProps != null) {
                TargetPlatformHelper.addEnvironmentProperties((Dictionary)environmentProperties, (IExecutionEnvironment)env, (Properties)profileProps);
                break;
            }
            --i;
        }
        return new Dictionary[]{environmentProperties};
    }

    protected IExecutionEnvironment[] getMatchingEnvironments() throws CoreException {
        IVMInstall install = VMHelper.getVMInstall(this.fLaunchConfiguration, this.fModels);
        return install == null ? new IExecutionEnvironment[]{} : LaunchValidationOperation.getMatchingEEs(install);
    }

    static IExecutionEnvironment[] getMatchingEEs(IVMInstall install) {
        return (IExecutionEnvironment[])Arrays.stream(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()).filter(env -> Arrays.stream(env.getCompatibleVMs()).anyMatch(install::equals)).toArray(IExecutionEnvironment[]::new);
    }

    private Properties getJavaProfileProperties(String ee) {
        block24: {
            IPluginModelBase model = PluginRegistry.findModel((String)"system.bundle");
            if (model == null) {
                return null;
            }
            File location = new File(model.getInstallLocation());
            String filename = ee.replace('/', '_') + ".profile";
            try {
                if (location.isDirectory()) {
                    File file = new File(location, filename);
                    if (file.exists()) {
                        Throwable throwable = null;
                        Object var7_13 = null;
                        try (FileInputStream is = new FileInputStream(file);){
                            return LaunchValidationOperation.loadProperties(is);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    break block24;
                }
                Throwable throwable = null;
                Object var6_11 = null;
                try (ZipFile zipFile = new ZipFile(location, 1);){
                    ZipEntry entry = zipFile.getEntry(filename);
                    if (entry != null) {
                        return LaunchValidationOperation.loadProperties(zipFile.getInputStream(entry));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Properties loadProperties(InputStream is) throws IOException {
        Properties profile = new Properties();
        profile.load(is);
        return profile;
    }

    public boolean hasErrors() {
        return this.fOperation.hasErrors();
    }

    public Map<Object, Object[]> getInput() {
        return this.fOperation.getResolverErrors();
    }

    public boolean isEmpty() {
        return this.fOperation.getState().getHighestBundleId() == -1L;
    }

    protected State getState() {
        return this.fOperation.getState();
    }
}

