/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.configuration.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.launching.configuration.Activator;
import org.eclipse.rcptt.launching.configuration.LaunchConfigurationUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class Q7LaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Main";
    private static final String SOURCE_CONF_GROUP_LABEL = "&Target Launch Configuration";
    private static final String SOURCE_CONF_LINK_LABEL = "<a>Target:</a>";
    private static final String SELECT_CONF_BUTTON_LABEL = "Select...";
    private static final String SELECT_DIALOG_TITLE = "Select Configuration";
    private static final String SELECT_DIALOG_MESSAGE = "Select existing launch configuration";
    private static final String TARGET_LAUNCH_NOT_EXISTS_MESSAGE = "Target launch configuration does not exists";
    private static final String SELECT_LAUNCH_MESSAGE = "Select target launch configuration";
    private final Image fImage;
    private Combo accountCombo;
    private Text sourceConfField;
    ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Q7LaunchConfigurationTab.this.scheduleUpdateJob();
        }
    };

    public Q7LaunchConfigurationTab() {
        this.fImage = Activator.getImageDescriptor("icons/main_tab.gif").createImage();
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.createSelectPDEConfControls(composite);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Control child = (Control)e.widget;
                Rectangle bounds = child.getBounds();
                Rectangle area = scrollContainer.getClientArea();
                Point origin = scrollContainer.getOrigin();
                if (origin.x > bounds.x) {
                    origin.x = Math.max(0, bounds.x);
                }
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.x + area.width < bounds.x + bounds.width) {
                    origin.x = Math.max(0, bounds.x + bounds.width - area.width);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
                scrollContainer.setOrigin(origin);
            }
        };
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].addListener(26, listener);
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
    }

    private void createSelectPDEConfControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(SOURCE_CONF_GROUP_LABEL);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.createSourceConfLink((Composite)group);
        this.createSourceConfText((Composite)group);
        this.createSelectConfButton((Composite)group);
    }

    private void selectAccount(String account) {
        if (this.accountCombo == null) {
            return;
        }
        if (this.accountCombo.indexOf(account) == -1) {
            this.accountCombo.deselectAll();
        } else {
            this.accountCombo.setText(account);
        }
    }

    private void createSourceConfLink(Composite parent) {
        Link sourceLink = new Link(parent, 0);
        sourceLink.setText(SOURCE_CONF_LINK_LABEL);
        sourceLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchConfiguration config;
                String sourceConfName = Q7LaunchConfigurationTab.this.getTargetConfName();
                if (sourceConfName.length() > 0 && (config = LaunchConfigurationUtils.findLaunchConfiguration(sourceConfName, "org.eclipse.pde.ui.RuntimeWorkbench")) != null) {
                    Q7LaunchConfigurationTab.this.navigateToLaunchConfiguration(config);
                }
            }
        });
    }

    private void navigateToLaunchConfiguration(ILaunchConfiguration config) {
        LaunchConfigurationsDialog mainDialog = (LaunchConfigurationsDialog)this.getLaunchConfigurationDialog();
        mainDialog.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)config));
        mainDialog.doInitialTreeSelection();
    }

    private void createSourceConfText(Composite parent) {
        this.sourceConfField = new Text(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.sourceConfField.setLayoutData((Object)gridData);
        this.sourceConfField.setEditable(false);
        this.sourceConfField.addModifyListener(this.modifyListener);
    }

    private void createSelectConfButton(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        Button button = new Button(buttonComposite, 8);
        button.setFont(buttonComposite.getFont());
        button.setText(SELECT_CONF_BUTTON_LABEL);
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        gd.widthHint = 61;
        gd.horizontalAlignment = 4;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Q7LaunchConfigurationTab.this.selectSourceConfig();
            }
        });
    }

    private void selectSourceConfig() {
        Object[] selected;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ConfigurationLabelProvider());
        Object[] launches = LaunchConfigurationUtils.getLaunches("org.eclipse.pde.ui.RuntimeWorkbench");
        dialog.setElements(launches);
        dialog.setTitle(SELECT_DIALOG_TITLE);
        dialog.setMessage(SELECT_DIALOG_MESSAGE);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0) {
            this.sourceConfField.setText(((ILaunchConfiguration)selected[0]).getName());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("aut-ecl-port", 5378);
        configuration.setAttribute("aut-tesla-port", 7926);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String source = null;
        String account = null;
        try {
            source = configuration.getAttribute("target-configuration", "");
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        this.sourceConfField.setText(source);
        this.selectAccount(account);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("target-configuration", this.getTargetConfName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration configuration) {
        String targetName = "";
        try {
            targetName = configuration.getAttribute("target-configuration", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (targetName.length() <= 0) {
            this.setErrorMessage(SELECT_LAUNCH_MESSAGE);
            return false;
        }
        ILaunchConfiguration target = LaunchConfigurationUtils.findLaunchConfiguration(targetName, "org.eclipse.pde.ui.RuntimeWorkbench");
        if (target == null) {
            this.setErrorMessage(TARGET_LAUNCH_NOT_EXISTS_MESSAGE);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String getTargetConfName() {
        return this.sourceConfField.getText();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void dispose() {
        this.fImage.dispose();
        super.dispose();
    }

    class ConfigurationLabelProvider
    extends LabelProvider {
        ConfigurationLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)element;
                Image image = null;
                try {
                    ILaunchConfigurationType type = config.getType();
                    image = DebugUITools.getImage((String)type.getIdentifier());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)element;
                return config.getName();
            }
            return null;
        }
    }
}

