/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.ChainElement;
import org.eclipse.jdt.internal.ui.text.ChainType;

public final class ChainElementAnalyzer {
    private static final Map<String, IType> typeCache = new HashMap<String, IType>();
    private static final Predicate<IField> NON_STATIC_FIELDS_ONLY_FILTER = t -> {
        try {
            return !Flags.isStatic((int)t.getFlags());
        }
        catch (JavaModelException e) {
            return true;
        }
    };
    private static final Predicate<IMethod> RELEVANT_NON_STATIC_METHODS_ONLY_FILTER = m -> {
        try {
            return !Flags.isStatic((int)m.getFlags()) && !ChainElementAnalyzer.isVoid(m) && !m.isConstructor();
        }
        catch (JavaModelException e) {
            return false;
        }
    };
    private static final Predicate<IField> STATIC_FIELDS_ONLY_FILTER = t -> {
        try {
            return Flags.isStatic((int)t.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    };
    private static final Predicate<IMethod> STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER = m -> {
        try {
            return Flags.isStatic((int)m.getFlags()) && !ChainElementAnalyzer.isVoid(m) && !m.isConstructor();
        }
        catch (JavaModelException e) {
            return false;
        }
    };

    private ChainElementAnalyzer() {
    }

    private static boolean isVoid(IMethod m) {
        try {
            return String.valueOf('V').equals(m.getReturnType());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static Collection<IJavaElement> findVisibleInstanceFieldsAndRelevantInstanceMethods(ChainType type, ChainType receiverType) {
        return ChainElementAnalyzer.findFieldsAndMethods(type, receiverType, NON_STATIC_FIELDS_ONLY_FILTER, RELEVANT_NON_STATIC_METHODS_ONLY_FILTER);
    }

    public static Collection<IJavaElement> findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(ChainType type, ChainType receiverType) {
        return ChainElementAnalyzer.findFieldsAndMethods(type, receiverType, STATIC_FIELDS_ONLY_FILTER, STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER);
    }

    private static Collection<IJavaElement> findFieldsAndMethods(ChainType type, ChainType receiverType, Predicate<IField> fieldFilter, Predicate<IMethod> methodFilter) {
        LinkedHashMap<String, IMethod> tmp = new LinkedHashMap<String, IMethod>();
        for (IType cur : ChainElementAnalyzer.findAllSupertypesIncludingArgument(type)) {
            String key;
            int n;
            int n2;
            IMethod[] iMethodArray;
            try {
                iMethodArray = cur.getMethods();
                n2 = iMethodArray.length;
                n = 0;
                while (n < n2) {
                    IMethod method = iMethodArray[n];
                    if (methodFilter.test(method) && ChainElementAnalyzer.methodCanBeSeenBy(method, receiverType.getType()) && !tmp.containsKey(key = method.getKey())) {
                        tmp.put(key, method);
                    }
                    ++n;
                }
            }
            catch (JavaModelException method) {
                // empty catch block
            }
            try {
                iMethodArray = cur.getFields();
                n2 = iMethodArray.length;
                n = 0;
                while (n < n2) {
                    IMethod field = iMethodArray[n];
                    if (fieldFilter.test((IField)field) && ChainElementAnalyzer.fieldCanBeSeenBy((IField)field, receiverType.getType()) && !tmp.containsKey(key = field.getKey())) {
                        tmp.put(key, field);
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return tmp.values();
    }

    private static List<IType> findAllSupertypesIncludingArgument(ChainType type) {
        if (type.getPrimitiveType() != null) {
            return Collections.emptyList();
        }
        LinkedList<IType> supertypes = new LinkedList<IType>();
        LinkedList<IType> queue = new LinkedList<IType>();
        queue.add(type.getType());
        while (!queue.isEmpty()) {
            IType superType = (IType)queue.poll();
            if (superType == null || supertypes.contains(superType)) continue;
            supertypes.add(superType);
            try {
                String superClass = superType.getSuperclassTypeSignature();
                if (superClass != null) {
                    IType superClassType = ChainElementAnalyzer.getTypeFromSignature(type.getType().getJavaProject(), superClass, superType);
                    queue.add(superClassType);
                }
                String[] stringArray = superType.getSuperInterfaceTypeSignatures();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String interfc = stringArray[n2];
                    IType interfcType = ChainElementAnalyzer.getTypeFromSignature(type.getType().getJavaProject(), interfc, superType);
                    queue.add(interfcType);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return supertypes;
    }

    public static boolean isAssignable(ChainElement edge, IType expectedType, int expectedDimension) {
        if (expectedDimension <= edge.getReturnTypeDimension()) {
            IType base = edge.getReturnType().getType();
            if (ChainElementAnalyzer.isAssignmentCompatible(base, expectedType)) {
                return true;
            }
            LinkedList<IType> supertypes = new LinkedList<IType>();
            supertypes.add(base);
            String expectedSignature = expectedType.getFullyQualifiedName();
            while (!supertypes.isEmpty()) {
                IType type = (IType)supertypes.poll();
                String typeSignature = type.getFullyQualifiedName();
                if (typeSignature.equals(expectedSignature)) {
                    return true;
                }
                try {
                    if (type.getSuperclassTypeSignature() == null) continue;
                    IType superclass = ChainElementAnalyzer.getTypeFromSignature(type.getJavaProject(), type.getSuperclassTypeSignature(), type);
                    if (superclass != null) {
                        supertypes.add(superclass);
                    }
                    String[] stringArray = type.getSuperInterfaceTypeSignatures();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String intf = stringArray[n2];
                        IType intfType = ChainElementAnalyzer.getTypeFromSignature(type.getJavaProject(), intf, type);
                        supertypes.add(intfType);
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAssignmentCompatible(IType base, IType expectedType) {
        LinkedList<IType> types = new LinkedList<IType>();
        types.add(base);
        try {
            while (!types.isEmpty()) {
                IType type = (IType)types.poll();
                if (type.getSuperclassTypeSignature() != null && !"java.lang.Object".equals(type.getSuperclassName())) {
                    IType superType = ChainElementAnalyzer.getTypeFromSignature(type.getJavaProject(), type.getSuperclassTypeSignature(), type);
                    if (expectedType.equals(superType)) {
                        return true;
                    }
                    types.add(superType);
                }
                if (type.getSuperInterfaceNames().length <= 0) continue;
                String[] stringArray = type.getSuperInterfaceTypeSignatures();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String iface = stringArray[n2];
                    IType ifaceType = ChainElementAnalyzer.getTypeFromSignature(type.getJavaProject(), iface, type);
                    if (expectedType.equals(ifaceType)) {
                        return true;
                    }
                    types.add(ifaceType);
                    ++n2;
                }
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public static List<ChainType> resolveBindingsForExpectedTypes(IJavaProject proj, CompletionContext ctx) {
        LinkedList<ChainType> types = new LinkedList<ChainType>();
        IType expectedTypeSig = ChainElementAnalyzer.getExpectedType(proj, ctx);
        if (expectedTypeSig == null) {
            char[][] expectedTypes = ctx.getExpectedTypesSignatures();
            String typeSig = new String(expectedTypes[0]);
            int dim = ChainElementAnalyzer.getArrayDimension(ctx.getExpectedTypesSignatures());
            ChainType type = new ChainType(typeSig, dim);
            types.add(type);
        } else {
            types.add(new ChainType(expectedTypeSig));
        }
        return types;
    }

    public static IType getExpectedType(IJavaProject proj, CompletionContext ctx) {
        IType expected = null;
        String fqExpectedType = ChainElementAnalyzer.getExpectedFullyQualifiedTypeName(ctx);
        if (fqExpectedType != null) {
            try {
                expected = proj.findType(fqExpectedType);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return expected;
    }

    public static String getExpectedFullyQualifiedTypeName(CompletionContext ctx) {
        String fqExpectedType = null;
        char[][] expectedTypes = ctx.getExpectedTypesSignatures();
        if (expectedTypes != null && expectedTypes.length > 0) {
            fqExpectedType = SignatureUtil.stripSignatureToFQN(new String(expectedTypes[0]));
        }
        return fqExpectedType;
    }

    private static int getArrayDimension(char[][] expectedTypesSignatures) {
        if (expectedTypesSignatures != null && expectedTypesSignatures.length > 0) {
            return Signature.getArrayCount((String)new String(expectedTypesSignatures[0]));
        }
        return 0;
    }

    public static IType getTypeFromSignature(IJavaProject proj, String typeSig, IType declType) {
        IType cType = typeCache.get(typeSig);
        if (cType != null) {
            return cType;
        }
        boolean isResolved = true;
        String eType = Signature.getElementType((String)typeSig);
        if (eType.charAt(0) == 'Q') {
            isResolved = false;
        }
        String type = SignatureUtil.stripSignatureToFQN(typeSig);
        IType res = null;
        try {
            res = proj.findType(type);
            if (res != null) {
                if (isResolved) {
                    typeCache.put(typeSig, res);
                }
                return res;
            }
            String[][] resType = declType.resolveType(type);
            if (resType != null) {
                String fqExpectedType = JavaModelUtil.concatenateName(resType[0][0], resType[0][1]);
                res = proj.findType(fqExpectedType);
                if (isResolved) {
                    typeCache.put(typeSig, res);
                }
                return res;
            }
        }
        catch (JavaModelException e) {
            return null;
        }
        return null;
    }

    private static boolean methodCanBeSeenBy(IMethod mb, IType invocationType) {
        try {
            if (Flags.isPublic((int)mb.getFlags())) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (invocationType.equals(mb.getDeclaringType())) {
            return true;
        }
        String invocationPackage = invocationType.getPackageFragment().getElementName();
        String methodPackage = mb.getDeclaringType().getPackageFragment().getElementName();
        try {
            if (Flags.isProtected((int)mb.getFlags()) && invocationPackage.equals(methodPackage)) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        try {
            if (Flags.isPrivate((int)mb.getFlags())) {
                IType mTypeRoot = mb.getDeclaringType();
                while (invocationType.getDeclaringType() != null) {
                    mTypeRoot = mTypeRoot.getDeclaringType();
                }
                IType invTypeRoot = invocationType;
                while (invTypeRoot.getDeclaringType() != null) {
                    invTypeRoot = invTypeRoot.getDeclaringType();
                }
                return mTypeRoot.equals(invTypeRoot);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return invocationPackage.equals(methodPackage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean fieldCanBeSeenBy(IField fb, IType invocationType) {
        try {
            if (Flags.isPublic((int)fb.getFlags())) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (invocationType.equals(fb.getDeclaringType())) {
            return true;
        }
        String invocationpackage = invocationType.getPackageFragment().getElementName();
        String fieldPackage = fb.getDeclaringType().getPackageFragment().getElementName();
        try {
            if (Flags.isProtected((int)fb.getFlags())) {
                if (invocationType.equals(fb.getDeclaringType())) {
                    return true;
                }
                if (invocationpackage.equals(fieldPackage)) {
                    return true;
                }
                IType currType = invocationType;
                while (currType.getSuperclassTypeSignature() != null) {
                    if (!(currType = ChainElementAnalyzer.getTypeFromSignature(currType.getJavaProject(), currType.getSuperclassTypeSignature(), currType)).equals(fb.getDeclaringType())) continue;
                    return true;
                }
            }
        }
        catch (JavaModelException currType) {
            // empty catch block
        }
        try {
            if (Flags.isPrivate((int)fb.getFlags())) {
                IType fTypeRoot = fb.getDeclaringType();
                while (invocationType.getDeclaringType() != null) {
                    fTypeRoot = fTypeRoot.getDeclaringType();
                }
                IType invTypeRoot = invocationType;
                while (invTypeRoot.getDeclaringType() != null) {
                    invTypeRoot = invTypeRoot.getDeclaringType();
                }
                if (fTypeRoot.equals(invTypeRoot)) {
                    return true;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (!invocationpackage.equals(fieldPackage)) {
            return false;
        }
        return false;
    }

    public static boolean isPrimitive(String typeSig) {
        String elementType = Signature.getElementType((String)typeSig);
        int kind = Signature.getTypeSignatureKind((String)elementType);
        return kind == 2 || kind == 3;
    }
}

