/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class RenameVirtualMethodProcessor
extends RenameMethodProcessor {
    private IMethod fOriginalMethod = this.getMethod();
    private boolean fActivationChecked;
    private ITypeHierarchy fCachedHierarchy = null;

    public RenameVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    public RenameVirtualMethodProcessor(IMethod method, JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(method);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
        this.fOriginalMethod = this.getMethod();
    }

    public RenameVirtualMethodProcessor(IMethod topLevel, IMethod[] ripples, TextChangeManager changeManager, ITypeHierarchy hierarchy, GroupCategorySet categorySet) {
        super(topLevel, changeManager, categorySet);
        this.fActivationChecked = true;
        this.fCachedHierarchy = hierarchy;
        this.setMethodsToRename(ripples);
    }

    private ITypeHierarchy getCachedHierarchy(IType declaring, IProgressMonitor monitor) throws JavaModelException {
        if (this.fCachedHierarchy != null && declaring.equals(this.fCachedHierarchy.getType())) {
            return this.fCachedHierarchy;
        }
        this.fCachedHierarchy = declaring.newTypeHierarchy(Progress.subMonitor(monitor, 1));
        return this.fCachedHierarchy;
    }

    public IMethod getOriginalMethod() {
        return this.fOriginalMethod;
    }

    @Override
    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameVirtualMethodAvailable(this.getMethod());
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.checkInitialConditions(monitor);
        if (result.hasFatalError()) {
            return result;
        }
        try {
            monitor.beginTask("", 3);
            if (!this.fActivationChecked) {
                IMethod topmost;
                IMethod method;
                this.fOriginalMethod = method = this.getMethod();
                ITypeHierarchy hierarchy = null;
                IType declaringType = method.getDeclaringType();
                if (!declaringType.isInterface()) {
                    hierarchy = this.getCachedHierarchy(declaringType, Progress.subMonitor(monitor, 1));
                }
                if (MethodChecks.isVirtual(topmost = this.getMethod())) {
                    topmost = MethodChecks.getTopmostMethod(this.getMethod(), hierarchy, monitor);
                }
                if (topmost != null) {
                    this.initializeWithTopMostImplementation(topmost);
                }
                this.fActivationChecked = true;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected void initializeWithTopMostImplementation(IMethod topmost) {
        this.initialize(topmost);
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        try {
            pm.beginTask("", 9);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions(Progress.subMonitor(pm, 7), checkContext));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod method = this.getMethod();
            IType declaring = method.getDeclaringType();
            ITypeHierarchy hierarchy = this.getCachedHierarchy(declaring, Progress.subMonitor(pm, 1));
            String name = this.getNewElementName();
            if (declaring.isInterface()) {
                if (this.isSpecialCase()) {
                    result.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_special_case);
                }
                pm.worked(1);
                IMethod[] iMethodArray = this.relatedTypeDeclaresMethodName(Progress.subMonitor(pm, 1), method, name);
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod relatedMethod = iMethodArray[n2];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)relatedMethod);
                    result.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_already_defined, context);
                    ++n2;
                }
            } else {
                if (this.classesDeclareOverridingNativeMethod(hierarchy.getAllSubtypes(declaring))) {
                    result.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_requieres_renaming_native, new String[]{BasicElementLabels.getJavaElementName(method.getElementName()), "UnsatisfiedLinkError"}));
                }
                IMethod[] iMethodArray = RenameVirtualMethodProcessor.hierarchyDeclaresMethodName(Progress.subMonitor(pm, 1), hierarchy, method, name);
                int n = iMethodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IMethod hierarchyMethod = iMethodArray[n3];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                    if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                        result.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares2, BasicElementLabels.getJavaElementName(name)), context);
                    } else {
                        result.addWarning(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares1, BasicElementLabels.getJavaElementName(name)), context);
                    }
                    ++n3;
                }
            }
            this.fCachedHierarchy = null;
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IMethod[] relatedTypeDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        try {
            HashSet<IMethod> result = new HashSet<IMethod>();
            Set<IType> types = this.getRelatedTypes();
            pm.beginTask("", types.size());
            for (IType type : types) {
                IMethod found = Checks.findMethod(method, type);
                IType declaring = found.getDeclaringType();
                result.addAll(Arrays.asList(RenameVirtualMethodProcessor.hierarchyDeclaresMethodName(Progress.subMonitor(pm, 1), declaring.newTypeHierarchy(Progress.subMonitor(pm, 1)), found, newName)));
            }
            IMethod[] iMethodArray = result.toArray(new IMethod[result.size()]);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    private boolean isSpecialCase() throws CoreException {
        String[] noParams = new String[]{};
        String[] specialNames = new String[]{"toString", "toString", "toString", "toString", "equals", "equals", "getClass", "getClass", "hashCode", "notify", "notifyAll", "wait", "wait", "wait"};
        String[][] specialParamTypes = new String[][]{noParams, noParams, noParams, noParams, {"QObject;"}, {"Qjava.lang.Object;"}, noParams, noParams, noParams, noParams, noParams, {"J", "I"}, {"J"}, noParams};
        String[] specialReturnTypes = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "Z", "Z", "QClass;", "Qjava.lang.Class;", "I", "V", "V", "V", "V", "V"};
        Assert.isTrue((specialNames.length == specialParamTypes.length && specialParamTypes.length == specialReturnTypes.length ? 1 : 0) != 0);
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(this.getNewElementName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), specialParamTypes[i]) && !specialReturnTypes[i].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set<IType> getRelatedTypes() {
        Set<IMethod> methods = this.getMethodsToRename();
        HashSet<IType> result = new HashSet<IType>(methods.size());
        for (IMethod method : methods) {
            result.add(method.getDeclaringType());
        }
        return result;
    }

    private boolean classesDeclareOverridingNativeMethod(IType[] classes) throws CoreException {
        IType[] iTypeArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (!method.equals(this.getMethod()) && JdtFlags.isNative((IMember)method) && Checks.findSimilarMethod(this.getMethod(), new IMethod[]{method}) != null) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

