/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.synchronize.SyncInfo;

public class DiffTreeStatistics {
    protected Map<Integer, Long> stats = Collections.synchronizedMap(new HashMap());

    public void add(int state) {
        Long count = this.stats.get(state);
        if (count == null) {
            count = 0L;
        }
        this.stats.put(state, count + 1L);
    }

    public void remove(int state) {
        Integer kind = state;
        Long count = this.stats.get(kind);
        if (count != null) {
            long newCount = count.intValue() - 1;
            if (newCount > 0L) {
                this.stats.put(kind, newCount);
            } else {
                this.stats.remove(kind);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countFor(int state, int mask) {
        if (mask == 0) {
            Long count = this.stats.get(state);
            return count == null ? 0L : count;
        }
        Set<Integer> keySet = this.stats.keySet();
        long count = 0L;
        Map<Integer, Long> map = this.stats;
        synchronized (map) {
            for (Integer key : keySet) {
                if ((key & mask) != state) continue;
                count += (long)this.stats.get(key).intValue();
            }
        }
        return count;
    }

    public void clear() {
        this.stats.clear();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Integer kind : this.stats.keySet()) {
            out.append(SyncInfo.kindToString(kind) + ": " + String.valueOf(this.stats.get(kind)) + "\n");
        }
        return out.toString();
    }

    public void add(IDiff delta) {
        int state = this.getState(delta);
        this.add(state);
    }

    public void remove(IDiff delta) {
        int state = this.getState(delta);
        this.remove(state);
    }

    private int getState(IDiff delta) {
        int state = delta.getKind();
        if (delta instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)delta;
            state |= twd.getDirection();
        }
        return state;
    }
}

