/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.internal.ui.views.target.StateViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class TargetStateView
extends PageBookView {
    public static final String VIEW_ID = "org.eclipse.pde.ui.TargetPlatformState";
    private final Map<IPageBookViewPage, IWorkbenchPart> fPagesToParts;
    private final Map<IWorkbenchPart, IPageBookViewPage> fPartsToPages = new HashMap<IWorkbenchPart, IPageBookViewPage>(4);
    private IWorkbenchPart fPartState;

    public TargetStateView() {
        this.fPagesToParts = new HashMap<IPageBookViewPage, IWorkbenchPart>(4);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.fPartState = new DummyPart((IWorkbenchPartSite)site);
    }

    public void dispose() {
        super.dispose();
        this.fPartState.dispose();
        this.fPartState = null;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.target_platform_state");
    }

    protected IPage createDefaultPage(PageBook book) {
        return this.createPage(this.getDefaultPart());
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPageBookViewPage page = this.fPartsToPages.get(part);
        if (page == null && !this.fPartsToPages.containsKey(part)) {
            page = this.createPage(part);
        }
        if (page != null) {
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return this.getDefaultPart();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    private IPageBookViewPage createPage(IWorkbenchPart part) {
        StateViewPage page = new StateViewPage(this);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        this.fPartsToPages.put(part, (IPageBookViewPage)page);
        this.fPagesToParts.put((IPageBookViewPage)page, part);
        return page;
    }

    private IWorkbenchPart getDefaultPart() {
        return this.fPartState;
    }

    static class DummyPart
    implements IWorkbenchPart {
        private IWorkbenchPartSite fSite;

        public DummyPart(IWorkbenchPartSite site) {
            this.fSite = site;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
            this.fSite = null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public IWorkbenchPartSite getSite() {
            return this.fSite;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }
    }
}

