/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.views.features.model.IProductModelListener;
import org.eclipse.pde.internal.ui.views.features.model.WorkspaceProductModelManager;

public class ProductModelManager {
    private final Collection<IProductModelListener> fListeners = new ArrayList<IProductModelListener>();
    private final WorkspaceProductModelManager fWorkspaceProductModelManager = new WorkspaceProductModelManager();
    private Map<String, IProductModel> fProductModels;

    public ProductModelManager() {
        this.fWorkspaceProductModelManager.addModelProviderListener(this::handleModelProviderChange);
    }

    private void handleModelProviderChange(IModelProviderEvent event) {
        IProductModel productModel;
        IModel model;
        this.ensureInitialized();
        IModel[] iModelArray = event.getRemovedModels();
        int n = iModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            model = iModelArray[n2];
            productModel = (IProductModel)model;
            this.fProductModels.remove(productModel.getProduct().getId());
            ++n2;
        }
        iModelArray = event.getAddedModels();
        n = iModelArray.length;
        n2 = 0;
        while (n2 < n) {
            model = iModelArray[n2];
            productModel = (IProductModel)model;
            this.fProductModels.put(productModel.getProduct().getId(), productModel);
            ++n2;
        }
        iModelArray = event.getChangedModels();
        n = iModelArray.length;
        n2 = 0;
        while (n2 < n) {
            model = iModelArray[n2];
            productModel = (IProductModel)model;
            this.fProductModels.put(productModel.getProduct().getId(), productModel);
            ++n2;
        }
        for (IProductModelListener listener : this.fListeners) {
            listener.modelsChanged();
        }
    }

    public boolean isInitialized() {
        return this.fProductModels != null;
    }

    private void ensureInitialized() {
        if (this.fProductModels == null) {
            this.fProductModels = new HashMap<String, IProductModel>();
            IProductModel[] iProductModelArray = this.fWorkspaceProductModelManager.getProductModels();
            int n = iProductModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProductModel productModel = iProductModelArray[n2];
                this.fProductModels.put(productModel.getProduct().getId(), productModel);
                ++n2;
            }
        }
    }

    public IProductModel findProductModel(String id) {
        this.ensureInitialized();
        return this.fProductModels.get(id);
    }

    public IProductModel[] getModels() {
        this.ensureInitialized();
        return this.fWorkspaceProductModelManager.getProductModels();
    }

    public void addProductModelListener(IProductModelListener listener) {
        this.fListeners.add(listener);
    }

    public void removeProductModelListener(IProductModelListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void shutdown() {
        this.fWorkspaceProductModelManager.shutdown();
    }
}

