/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.TargetReferenceBundleContainer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetReferenceLocationWizard;
import org.eclipse.pde.ui.target.ITargetLocationHandler;
import org.eclipse.swt.graphics.Image;

public class TargetReferenceBundleContainerAdapterFactory
implements IAdapterFactory {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final DelegatingStyledCellLabelProvider.IStyledLabelProvider STYLE_LABEL_PROVIDER = new WrappedStyledBundleLabelProvider();
    public static final ILabelProvider LABEL_PROVIDER = new LabelProvider(){
        private Image image;

        public String getText(Object element) {
            if (element instanceof TargetReferenceBundleContainer) {
                TargetReferenceBundleContainer container = (TargetReferenceBundleContainer)element;
                String name = container.targetDefinition().map(ITargetDefinition::getName).orElse(null);
                if (name != null && !name.isBlank()) {
                    return name;
                }
                try {
                    return container.getLocation(true);
                }
                catch (CoreException e) {
                    return container.getUri();
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof TargetReferenceBundleContainer) {
                if (this.image == null) {
                    this.image = PDEPluginImages.DESC_TARGET_DEFINITION.createImage();
                }
                return this.image;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            STYLE_LABEL_PROVIDER.dispose();
        }
    };
    private static final ITargetLocationHandler LOCATION_HANDLER = new ITargetLocationHandler(){

        @Override
        public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof TargetReferenceBundleContainer) {
                    TargetReferenceBundleContainer targetRefrenceBundleContainer = (TargetReferenceBundleContainer)location;
                    targetRefrenceBundleContainer.reload();
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        @Override
        public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
            Object segment = treePath.getLastSegment();
            if (segment instanceof TargetReferenceBundleContainer) {
                TargetReferenceLocationWizard wizard = new TargetReferenceLocationWizard();
                wizard.setTarget(target);
                wizard.setBundleContainer((TargetReferenceBundleContainer)segment);
                return wizard;
            }
            return null;
        }

        @Override
        public boolean canEdit(ITargetDefinition target, TreePath treePath) {
            return treePath.getLastSegment() instanceof TargetReferenceBundleContainer;
        }
    };
    private static final ITreeContentProvider TREE_CONTENT_PROVIDER = new ITreeContentProvider(){

        public boolean hasChildren(Object element) {
            if (element instanceof TargetReferenceBundleContainer) {
                return true;
            }
            if (element instanceof TargetLocationWrapper) {
                TargetLocationWrapper wrapper = (TargetLocationWrapper)element;
                return wrapper.as(ITreeContentProvider.class).map(provider -> provider.hasChildren(targetLocationWrapper.wrappedItem)).orElse(Boolean.FALSE);
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return EMPTY_OBJECTS;
        }

        public Object[] getChildren(Object parentElement) {
            TargetReferenceBundleContainer container;
            ITargetLocation[] targetLocations;
            if (parentElement instanceof TargetReferenceBundleContainer && (targetLocations = (ITargetLocation[])(container = (TargetReferenceBundleContainer)parentElement).targetDefinition().map(ITargetDefinition::getTargetLocations).orElse(null)) != null && targetLocations.length > 0) {
                return Arrays.stream(targetLocations).map(TargetLocationWrapper::new).toArray();
            }
            if (parentElement instanceof TargetLocationWrapper) {
                TargetLocationWrapper wrapper = (TargetLocationWrapper)parentElement;
                return wrapper.as(ITreeContentProvider.class).map(provider -> provider.getChildren(targetLocationWrapper.wrappedItem)).stream().flatMap(Arrays::stream).map(TargetLocationWrapper::new).toArray();
            }
            return EMPTY_OBJECTS;
        }
    };

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof TargetReferenceBundleContainer) {
            if (adapterType == ILabelProvider.class) {
                return adapterType.cast(LABEL_PROVIDER);
            }
            if (adapterType == ITargetLocationHandler.class) {
                return adapterType.cast(LOCATION_HANDLER);
            }
            if (adapterType == ITreeContentProvider.class) {
                return adapterType.cast(TREE_CONTENT_PROVIDER);
            }
        }
        if (adaptableObject instanceof TargetLocationWrapper) {
            if (adapterType == DelegatingStyledCellLabelProvider.IStyledLabelProvider.class) {
                return adapterType.cast(STYLE_LABEL_PROVIDER);
            }
            if (adapterType == ITreeContentProvider.class) {
                return adapterType.cast(TREE_CONTENT_PROVIDER);
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITargetLocationHandler.class, ITreeContentProvider.class, DelegatingStyledCellLabelProvider.IStyledLabelProvider.class};
    }

    public static final class TargetLocationWrapper {
        private final Object wrappedItem;

        public TargetLocationWrapper(Object location) {
            this.wrappedItem = location;
        }

        <T> Optional<T> as(Class<T> target) {
            return Optional.ofNullable(Adapters.adapt((Object)this.wrappedItem, target));
        }

        static /* synthetic */ Object access$0(TargetLocationWrapper targetLocationWrapper) {
            return targetLocationWrapper.wrappedItem;
        }
    }

    private static final class WrappedStyledBundleLabelProvider
    extends StyledBundleLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public WrappedStyledBundleLabelProvider() {
            super(false, false);
        }

        @Override
        protected StyledString getStyledString(Object element) {
            if (element instanceof TargetLocationWrapper) {
                element = ((TargetLocationWrapper)element).wrappedItem;
            }
            return super.getStyledString(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof TargetLocationWrapper) {
                element = ((TargetLocationWrapper)element).wrappedItem;
            }
            return super.getImage(element);
        }

        public StyledString getStyledText(Object element) {
            return this.getStyledString(element);
        }
    }
}

