/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IVersionable;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

abstract class IUDetailsSection<T extends IVersionable>
extends PDESection
implements IPartSelectionListener {
    private final Function<Object, T> fSelectionExtractor;
    private T fCurrentItem;
    private FormEntry fIdText;
    private FormEntry fVersionText;

    public IUDetailsSection(PDEFormPage page, Composite parent, String title, String desc, Function<Object, T> selectionExtractor) {
        super(page, parent, 128);
        this.fSelectionExtractor = selectionExtractor;
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    public void cancelEdit() {
        this.fIdText.cancelEdit();
        this.fVersionText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        TransferData[] transferDataArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData type = transferDataArray[n2];
            Transfer[] transferArray = transfers;
            int n3 = transfers.length;
            int n4 = 0;
            while (n4 < n3) {
                Transfer transfer = transferArray[n4];
                if (transfer.isSupportedType(type)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.fIdText.commit();
        this.fVersionText.commit();
        super.commit(onSave);
    }

    @Override
    public final void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        this.fIdText = new FormEntry(container, toolkit, PDEUIMessages.SiteContentDetails_id, null, false);
        this.fIdText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (IUDetailsSection.this.fCurrentItem != null) {
                    try {
                        String value = text.getValue();
                        IUDetailsSection.this.applyId(value.isEmpty() ? null : value);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fIdText);
        this.fIdText.setEditable(this.isEditable());
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.SiteContentDetails_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (IUDetailsSection.this.fCurrentItem != null) {
                    try {
                        String value = text.getValue();
                        IUDetailsSection.this.applyVersion(value.isEmpty() ? null : value);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fVersionText);
        this.fVersionText.setEditable(this.isEditable());
        this.onCreateClient(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
    }

    protected void onCreateClient(Composite container, FormToolkit toolkit) {
    }

    protected void applyId(String value) throws CoreException {
        this.fCurrentItem.setId(value);
    }

    protected void applyVersion(String value) throws CoreException {
        this.fCurrentItem.setVersion(value);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public final void refresh() {
        if (this.fCurrentItem == null) {
            this.clearFields();
        } else {
            this.fillControls(this.fCurrentItem);
        }
        super.refresh();
    }

    protected void fillControls(T currentItem) {
        this.fIdText.setValue(currentItem.getId(), true);
        this.fVersionText.setValue(currentItem.getVersion(), true);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IVersionable item = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            item = (IVersionable)this.fSelectionExtractor.apply(structured.getFirstElement());
        }
        this.fCurrentItem = item;
        this.refresh();
    }

    public void setFocus() {
        if (this.fIdText != null) {
            this.fIdText.getText().setFocus();
        }
    }

    protected void clearFields() {
        this.fIdText.setValue(null, true);
        this.fVersionText.setValue(null, true);
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    protected void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    protected T getCurrentItem() {
        return this.fCurrentItem;
    }
}

