/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.category.CategoryInputContext;
import org.eclipse.pde.internal.ui.editor.category.CategoryInputContextManager;
import org.eclipse.pde.internal.ui.editor.category.CategoryOutlinePage;
import org.eclipse.pde.internal.ui.editor.category.CategorySourcePage;
import org.eclipse.pde.internal.ui.editor.category.CategoryUndoManager;
import org.eclipse.pde.internal.ui.editor.category.IUsPage;
import org.eclipse.pde.internal.ui.editor.category.RepositoryMetadataPage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class CategoryEditor
extends MultiSourceEditor {
    @Override
    protected String getEditorID() {
        return "org.eclipse.pde.ui.categoryEditor";
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        manager.putContext((IEditorInput)input, new CategoryInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(input.getFile());
    }

    @Override
    protected InputContextManager createInputContextManager() {
        CategoryInputContextManager contextManager = new CategoryInputContextManager(this);
        contextManager.setUndoManager(new CategoryUndoManager(this));
        return contextManager;
    }

    @Override
    public void monitoredFileAdded(IFile file) {
    }

    @Override
    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    @Override
    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    @Override
    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        try {
            IFileStore store = EFS.getStore((URI)input.getURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            manager.putContext((IEditorInput)in, new CategoryInputContext(this, (IEditorInput)in, true));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new CategoryInputContext(this, (IEditorInput)input, true));
    }

    @Override
    protected void contextMenuAboutToShow(IMenuManager manager) {
        super.contextMenuAboutToShow(manager);
    }

    @Override
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new IUsPage(this));
            this.addPage((IFormPage)new RepositoryMetadataPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("category-context");
    }

    @Override
    protected String computeInitialPageId() {
        return "ius";
    }

    @Override
    protected ISortableContentOutlinePage createContentOutline() {
        return new CategoryOutlinePage(this);
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new CategorySourcePage(editor, title, name);
    }

    @Override
    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof ISiteObject) {
            context = this.fInputContextManager.findContext("category-context");
        }
        return context;
    }
}

