/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;
import org.eclipse.pde.internal.ui.correction.Messages;

public class ReplaceExecEnvironment
extends AbstractManifestMarkerResolution {
    private final String fRequiredEE;

    public ReplaceExecEnvironment(int type, IMarker marker) {
        super(type, marker);
        this.fRequiredEE = this.marker.getAttribute("executionEnvironment.key", "JavaSE-1.8");
    }

    public String getLabel() {
        return NLS.bind((String)Messages.ReplaceExecEnvironment_Marker_Label, (Object)this.fRequiredEE);
    }

    @Override
    protected void createChange(BundleModel model) {
        IManifestHeader header = model.getBundle().getManifestHeader("Bundle-RequiredExecutionEnvironment");
        if (header instanceof RequiredExecutionEnvironmentHeader) {
            RequiredExecutionEnvironmentHeader reqHeader = (RequiredExecutionEnvironmentHeader)header;
            Set systemEnvs = TargetPlatformHelper.getPDEState().getfProvidedExecutionEnvironments();
            if (systemEnvs.contains(this.fRequiredEE)) {
                for (String ee : reqHeader.getEnvironments()) {
                    reqHeader.removeExecutionEnvironment(ee);
                }
                reqHeader.addExecutionEnvironment(this.fRequiredEE);
            }
        }
    }
}

