/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BndTargetLocationFactory
implements ITargetLocationFactory {
    private final String type;

    public BndTargetLocationFactory(String type) {
        this.type = Objects.requireNonNull(type);
    }

    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        if (this.type.equals(type)) {
            try {
                DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderFactoryIgnoringDOCTYPE().newDocumentBuilder();
                Document document = docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
                Element locationElement = document.getDocumentElement();
                if (this.type.equals(locationElement.getAttribute("type"))) {
                    return this.getTargetLocation(locationElement);
                }
            }
            catch (Exception e) {
                ILog.get().error("Problem reading target location " + type);
                return null;
            }
        }
        return null;
    }

    public boolean isElement(Node node, String elementName) {
        return node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase(elementName);
    }

    public abstract ITargetLocation getTargetLocation(Element var1) throws CoreException;
}

