/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.Arrays;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

final class ArrayFontDescriptor
extends FontDescriptor {
    private FontData[] data;
    private Font originalFont = null;

    public ArrayFontDescriptor(FontData[] data) {
        this.data = data;
    }

    public ArrayFontDescriptor(Font originalFont) {
        this(originalFont.getFontData());
        this.originalFont = originalFont;
    }

    @Override
    public FontData[] getFontData() {
        return ArrayFontDescriptor.copy(this.data);
    }

    @Override
    public Font createFont(Device device) {
        if (this.originalFont != null && this.originalFont.getDevice() == device) {
            return this.originalFont;
        }
        return new Font(device, this.data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayFontDescriptor) {
            ArrayFontDescriptor descr = (ArrayFontDescriptor)obj;
            if (descr.originalFont != this.originalFont) {
                return false;
            }
            if (this.originalFont != null) {
                return true;
            }
            return Arrays.equals(this.data, descr.data);
        }
        return false;
    }

    public int hashCode() {
        if (this.originalFont != null) {
            return this.originalFont.hashCode();
        }
        return Arrays.hashCode(this.data);
    }

    @Override
    public void destroyFont(Font previouslyCreatedFont) {
        if (previouslyCreatedFont == this.originalFont) {
            return;
        }
        previouslyCreatedFont.dispose();
    }
}

