/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.util;

import java.util.Comparator;
import org.eclipse.ant.internal.ui.dtd.util.IKeyHolder;

public class SortedSet {
    protected Comparator<Object> fComp;
    protected IKeyHolder fKeyHolder;
    protected SortedSet fNext;

    public SortedSet(IKeyHolder holder, Comparator<Object> comp) {
        this.fComp = comp;
        this.fKeyHolder = holder;
    }

    public SortedSet(Comparator<Object> comp) {
        this.fComp = comp;
    }

    public SortedSet(IKeyHolder holder) {
        this.fKeyHolder = holder;
    }

    public SortedSet() {
    }

    public void setKeyHolder(IKeyHolder holder) {
        this.fKeyHolder = holder;
    }

    public void setComparator(Comparator<Object> comp) {
        this.fComp = comp;
    }

    public boolean add(Object obj) {
        return this.internalAdd(obj, false) >= 0;
    }

    protected int internalAdd(Object obj, boolean always) {
        Object[] array = this.fKeyHolder.getKeys();
        if (array == null) {
            array = new Object[1];
            this.fKeyHolder.setKeys(array);
            array[0] = obj;
            return 0;
        }
        int i = 0;
        int comp = -1;
        while (i < array.length) {
            comp = this.fComp.compare(obj, array[i]);
            if (comp <= 0) break;
            ++i;
        }
        if (comp == 0 && !always) {
            return -1;
        }
        this.internalAdd(i, obj);
        return i;
    }

    protected void internalAdd(int i, Object obj) {
        Object[] array = this.fKeyHolder.getKeys();
        if (array == null) {
            array = new Object[]{obj};
            this.fKeyHolder.setKeys(array);
        } else {
            Object[] tmp = new Object[array.length + 1];
            System.arraycopy(array, 0, tmp, 0, i);
            tmp[i] = obj;
            System.arraycopy(array, i, tmp, i + 1, array.length - i);
            this.fKeyHolder.setKeys(tmp);
        }
    }

    public int addAlways(Object obj) {
        return this.internalAdd(obj, true);
    }

    public void append(Object obj) {
        Object[] array = this.fKeyHolder.getKeys();
        int len = array != null ? array.length : 0;
        this.internalAdd(len, obj);
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public int indexOf(Object obj) {
        Object[] array = this.fKeyHolder.getKeys();
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            int comp = this.fComp.compare(obj, array[i]);
            if (comp == 0) {
                return i;
            }
            if (comp < 0) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsIdentity(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public int indexOfIdentity(Object obj) {
        Object[] array = this.fKeyHolder.getKeys();
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (obj == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void other;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortedSet)) {
            return false;
        }
        SortedSet sortedSet = (SortedSet)o;
        Object[] array = this.fKeyHolder.getKeys();
        Object[] otherarray = other.fKeyHolder.getKeys();
        if (array == null != (otherarray == null)) {
            return false;
        }
        if (array == null) {
            return true;
        }
        if (array.length != otherarray.length) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] != otherarray[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void merge(SortedSet other) {
        Object[] array = this.fKeyHolder.getKeys();
        Object[] otherarray = other.fKeyHolder.getKeys();
        if (otherarray == null) {
            return;
        }
        if (array == null) {
            array = otherarray;
            return;
        }
        int ithis = 0;
        int iother = 0;
        int i = 0;
        int mthis = array.length;
        int mother = otherarray.length;
        Object[] tmp = new Object[mthis + mother];
        while (ithis < mthis && iother < mother) {
            int comp = this.fComp.compare(array[ithis], otherarray[iother]);
            tmp[i++] = comp <= 0 ? array[ithis++] : otherarray[iother++];
        }
        while (ithis < mthis) {
            tmp[i++] = array[ithis++];
        }
        while (iother < mother) {
            tmp[i++] = otherarray[iother++];
        }
    }

    public Object[] members() {
        Object[] array = this.fKeyHolder.getKeys();
        if (array == null) {
            return new Object[0];
        }
        return array;
    }

    public int size() {
        Object[] array = this.fKeyHolder.getKeys();
        return array == null ? 0 : array.length;
    }

    public void remove(int i) {
        Object[] array = this.fKeyHolder.getKeys();
        Object[] tmp = new Object[array.length - 1];
        System.arraycopy(array, 0, tmp, 0, i);
        System.arraycopy(array, i + 1, tmp, i, array.length - i - 1);
        this.fKeyHolder.setKeys(tmp);
    }

    public boolean remove(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeIdentity(Object obj) {
        int i = this.indexOfIdentity(obj);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    public SortedSet getNextSet() {
        return this.fNext;
    }

    public void setNextSet(SortedSet next) {
        this.fNext = next;
    }
}

