/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RowMatchMode implements Enumerator
{
    EXACT(0, "exact", "exact"),
    GLOB(1, "glob", "glob"),
    REGEXP(2, "regexp", "regexp");

    public static final int EXACT_VALUE = 0;
    public static final int GLOB_VALUE = 1;
    public static final int REGEXP_VALUE = 2;
    private static final RowMatchMode[] VALUES_ARRAY;
    public static final List<RowMatchMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RowMatchMode[]{EXACT, GLOB, REGEXP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RowMatchMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RowMatchMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RowMatchMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RowMatchMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RowMatchMode get(int value) {
        switch (value) {
            case 0: {
                return EXACT;
            }
            case 1: {
                return GLOB;
            }
            case 2: {
                return REGEXP;
            }
        }
        return null;
    }

    private RowMatchMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

