/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands;

import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.WriteExcelFile;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands.ExcelFileService;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class WriteExcelFileService
implements ICommandService {
    private static final String SHEET_NAME_PATTERN = "Sheet%d";
    private static final int SHEET_NAME_MAX_LENGTH = 31;

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        WriteExcelFile wef = (WriteExcelFile)command;
        EList tables = wef.getTables();
        String uri = wef.getUri();
        EclFile file = FileResolver.resolve((String)uri);
        boolean isAppend = wef.isAppend();
        Workbook book = (isAppend &= file.toFile().exists()) ? ExcelFileService.readBook(file) : ExcelFileService.createBook(file, uri);
        int sheetnum = 1;
        for (Table table : tables) {
            String sheetName = table.getPageName();
            if (sheetName == null || sheetName.equals("")) {
                sheetName = String.format(SHEET_NAME_PATTERN, sheetnum);
            }
            if (sheetName.length() > 31) {
                sheetName = sheetName.substring(0, 31);
            }
            Sheet sheet = book.getSheet(sheetName);
            boolean newSheet = false;
            if (sheet == null) {
                sheet = book.createSheet(sheetName);
                newSheet = true;
            }
            this.writeTable(sheet, table);
            if (newSheet) {
                this.autoSizeColumns(sheet);
            }
            context.getOutput().write((Object)table);
            ++sheetnum;
        }
        ExcelFileService.writeBook(book, file);
        return Status.OK_STATUS;
    }

    private void writeTable(Sheet sheet, Table table) {
        EList tableRows = table.getRows();
        int rownum = 0;
        while (rownum < tableRows.size()) {
            org.apache.poi.ss.usermodel.Row row = sheet.getRow(rownum);
            if (row == null) {
                row = sheet.createRow(rownum);
            }
            this.writeRow(row, (Row)tableRows.get(rownum));
            ++rownum;
        }
    }

    private void writeRow(org.apache.poi.ss.usermodel.Row row, Row tableRow) {
        EList cells = tableRow.getValues();
        int cellnum = 0;
        while (cellnum < cells.size()) {
            String value = (String)cells.get(cellnum);
            if (value != null && !value.equals("")) {
                Cell cell = row.getCell(cellnum);
                if (cell == null) {
                    cell = row.createCell(cellnum);
                }
                if (value.startsWith("=")) {
                    try {
                        cell.setCellFormula(value.replaceAll("^=", ""));
                    }
                    catch (FormulaParseException e) {
                        cell.setCellValue(value);
                    }
                } else {
                    cell.setCellValue(value);
                }
            }
            ++cellnum;
        }
    }

    private void autoSizeColumns(Sheet sheet) {
        int length = sheet.getRow(0).getLastCellNum();
        if (length == -1) {
            return;
        }
        int col = 0;
        while (col < length) {
            sheet.autoSizeColumn(col);
            ++col;
        }
    }
}

