/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleUtils {
    private final Bundle bundle;
    private final ILog log;

    public BundleUtils(Bundle bundle) {
        this.bundle = bundle;
        this.log = Platform.getLog((Bundle)bundle);
    }

    public String getID() {
        return this.bundle.getSymbolicName();
    }

    public IStatus createError(Throwable t) {
        if (t instanceof CoreException) {
            return ((CoreException)t).getStatus();
        }
        return new Status(4, this.getID(), t.getMessage(), t);
    }

    public void log(String msg, Throwable t) {
        this.log(this.createError(msg, t));
    }

    public void log(Throwable t) {
        this.log(this.createError(t));
    }

    public void log(IStatus status) {
        this.log.log(status);
    }

    public IStatus createStatus(int severity, String message) {
        return new Status(severity, this.getID(), message);
    }

    public IStatus createInfo(String message) {
        return this.createStatus(1, message);
    }

    public IStatus createError(String message, Throwable t) {
        if (t != null && (message == null || message.equals(t.getMessage()))) {
            return this.createError(t);
        }
        if (t instanceof CoreException) {
            return new MultiStatus(((CoreException)t).getStatus().getPlugin(), 0, new IStatus[]{this.createError(t)}, message, null);
        }
        return new Status(4, this.getID(), message, t);
    }

    public static Bundle getBundleOfAClass(Class<?> clazz) {
        return FrameworkUtil.getBundle(clazz);
    }

    public static BundleUtils create(Class<?> clazz) {
        return new BundleUtils(BundleUtils.getBundleOfAClass(clazz));
    }
}

