/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.cn.smart.hhmm.BigramDictionary;
import org.apache.lucene.analysis.cn.smart.hhmm.PathNode;
import org.apache.lucene.analysis.cn.smart.hhmm.SegGraph;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.analysis.cn.smart.hhmm.SegTokenPair;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.internal.hppc.ObjectCursor;

class BiSegGraph {
    private final IntObjectHashMap<ArrayList<SegTokenPair>> tokenPairListTable = new IntObjectHashMap();
    private List<SegToken> segTokenList;
    private static final BigramDictionary bigramDict = BigramDictionary.getInstance();

    public BiSegGraph(SegGraph segGraph) {
        this.segTokenList = segGraph.makeIndex();
        this.generateBiSegGraph(segGraph);
    }

    private void generateBiSegGraph(SegGraph segGraph) {
        double smooth = 0.1;
        int wordPairFreq = 0;
        int maxStart = segGraph.getMaxStart();
        double tinyDouble = 4.6296360596797126E-7;
        this.segTokenList = segGraph.makeIndex();
        List<SegToken> nextTokens = null;
        block0: for (int key = -1; key < maxStart; ++key) {
            if (!segGraph.isStartExist(key)) continue;
            List<SegToken> tokenList = segGraph.getStartList(key);
            for (SegToken t1 : tokenList) {
                double oneWordFreq = t1.weight;
                nextTokens = null;
                for (int next = t1.endOffset; next <= maxStart; ++next) {
                    if (!segGraph.isStartExist(next)) continue;
                    nextTokens = segGraph.getStartList(next);
                    break;
                }
                if (nextTokens == null) continue block0;
                for (SegToken t2 : nextTokens) {
                    char[] idBuffer = new char[t1.charArray.length + t2.charArray.length + 1];
                    System.arraycopy(t1.charArray, 0, idBuffer, 0, t1.charArray.length);
                    idBuffer[t1.charArray.length] = 64;
                    System.arraycopy(t2.charArray, 0, idBuffer, t1.charArray.length + 1, t2.charArray.length);
                    wordPairFreq = bigramDict.getFrequency(idBuffer);
                    double weight = -Math.log(smooth * (1.0 + oneWordFreq) / 2159997.0 + (1.0 - smooth) * ((1.0 - tinyDouble) * (double)wordPairFreq / (1.0 + oneWordFreq) + tinyDouble));
                    SegTokenPair tokenPair = new SegTokenPair(idBuffer, t1.index, t2.index, weight);
                    this.addSegTokenPair(tokenPair);
                }
            }
        }
    }

    public boolean isToExist(int to) {
        return this.tokenPairListTable.get(to) != null;
    }

    public List<SegTokenPair> getToList(int to) {
        return (List)this.tokenPairListTable.get(to);
    }

    public void addSegTokenPair(SegTokenPair tokenPair) {
        int to = tokenPair.to;
        if (!this.isToExist(to)) {
            ArrayList<SegTokenPair> newlist = new ArrayList<SegTokenPair>();
            newlist.add(tokenPair);
            this.tokenPairListTable.put(to, newlist);
        } else {
            List tokenPairList = (List)this.tokenPairListTable.get(to);
            tokenPairList.add(tokenPair);
        }
    }

    public int getToCount() {
        return this.tokenPairListTable.size();
    }

    public List<SegToken> getShortPath() {
        int lastNode;
        int current;
        int nodeCount = this.getToCount();
        ArrayList<PathNode> path = new ArrayList<PathNode>();
        PathNode zeroPath = new PathNode();
        zeroPath.weight = 0.0;
        zeroPath.preNode = 0;
        path.add(zeroPath);
        for (current = 1; current <= nodeCount; ++current) {
            List<SegTokenPair> edges = this.getToList(current);
            double minWeight = Double.MAX_VALUE;
            SegTokenPair minEdge = null;
            for (SegTokenPair edge : edges) {
                double weight = edge.weight;
                PathNode preNode = (PathNode)path.get(edge.from);
                if (!(preNode.weight + weight < minWeight)) continue;
                minWeight = preNode.weight + weight;
                minEdge = edge;
            }
            PathNode newNode = new PathNode();
            newNode.weight = minWeight;
            newNode.preNode = minEdge.from;
            path.add(newNode);
        }
        current = lastNode = path.size() - 1;
        IntArrayList rpath = new IntArrayList();
        ArrayList<SegToken> resultPath = new ArrayList<SegToken>();
        rpath.add(current);
        while (current != 0) {
            PathNode currentPathNode = (PathNode)path.get(current);
            int preNode = currentPathNode.preNode;
            rpath.add(preNode);
            current = preNode;
        }
        for (int j = rpath.size() - 1; j >= 0; --j) {
            int id = rpath.get(j);
            SegToken t = this.segTokenList.get(id);
            resultPath.add(t);
        }
        return resultPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ObjectCursor segList : this.tokenPairListTable.values()) {
            for (SegTokenPair pair : (ArrayList)segList.value) {
                sb.append(pair).append("\n");
            }
        }
        return sb.toString();
    }
}

