/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;

public class JREContainer
implements IClasspathContainer {
    private IVMInstall fVMInstall = null;
    private IPath fPath = null;
    private IJavaProject fProject = null;
    private static Map<IVMInstall, IClasspathEntry[]> fgClasspathEntries = new ConcurrentHashMap<IVMInstall, IClasspathEntry[]>();
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];
    private static Map<RuleKey, RuleEntry> fgClasspathEntriesWithRules = new ConcurrentHashMap<RuleKey, RuleEntry>();

    static {
        IVMInstallChangedListener listener = new IVMInstallChangedListener(){

            @Override
            public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
            }

            @Override
            public void vmAdded(IVMInstall newVm) {
            }

            @Override
            public void vmChanged(PropertyChangeEvent event) {
                Object source = event.getSource();
                if (source != null) {
                    fgClasspathEntries.remove(source);
                    this.removeRuleEntry(source);
                }
            }

            @Override
            public void vmRemoved(IVMInstall removedVm) {
                fgClasspathEntries.remove(removedVm);
                this.removeRuleEntry(removedVm);
            }

            private void removeRuleEntry(Object obj) {
                if (obj instanceof IVMInstall) {
                    IVMInstall install = (IVMInstall)obj;
                    fgClasspathEntriesWithRules.keySet().removeIf(key -> key.fInstall.equals(install));
                }
            }
        };
        JavaRuntime.addVMInstallChangedListener(listener);
    }

    private static IClasspathEntry[] getClasspathEntries(IVMInstall vm, IPath containerPath, IJavaProject project) {
        String id = JavaRuntime.getExecutionEnvironmentId(containerPath);
        IClasspathEntry[] entries = null;
        if (id == null) {
            entries = fgClasspathEntries.get(vm);
            if (entries == null) {
                entries = JREContainer.computeClasspathEntries(vm, project, id);
                fgClasspathEntries.put(vm, entries);
            }
        } else {
            if (LaunchingPlugin.DEBUG_JRE_CONTAINER) {
                LaunchingPlugin.trace("\tEE:\t" + id);
            }
            entries = JREContainer.computeClasspathEntries(vm, project, id);
        }
        return entries;
    }

    private static IClasspathEntry[] computeClasspathEntries(IVMInstall vm, IJavaProject project, String environmentId) {
        RuleEntry entry;
        IExecutionEnvironment environment;
        LibraryLocation[] libs = vm.getLibraryLocations();
        boolean overrideJavaDoc = false;
        if (libs == null) {
            libs = JavaRuntime.getLibraryLocations(vm);
            overrideJavaDoc = true;
        }
        IAccessRule[][] rules = null;
        if (environmentId != null && (environment = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(environmentId)) != null) {
            rules = environment.getAccessRules(vm, libs, project);
        }
        RuleKey key = null;
        if (vm != null && rules != null && environmentId != null && (entry = fgClasspathEntriesWithRules.get(key = new RuleKey(vm, environmentId))) != null && entry.equals(rules)) {
            return entry.getClasspathEntries();
        }
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].getSystemLibraryPath().isEmpty()) {
                IPath rootPath;
                IPath sourcePath = libs[i].getSystemLibrarySourcePath();
                if (sourcePath.isEmpty()) {
                    sourcePath = null;
                }
                if ((rootPath = libs[i].getPackageRootPath()).isEmpty()) {
                    rootPath = null;
                }
                IClasspathAttribute[] attributes = JREContainer.buildClasspathAttributes(vm, libs[i], overrideJavaDoc);
                IAccessRule[] libRules = null;
                libRules = rules != null ? rules[i] : EMPTY_RULES;
                entries.add(JavaCore.newLibraryEntry((IPath)libs[i].getSystemLibraryPath(), (IPath)sourcePath, (IPath)rootPath, (IAccessRule[])libRules, (IClasspathAttribute[])attributes, (boolean)false));
            }
            ++i;
        }
        IClasspathEntry[] cpEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        if (key != null && rules != null) {
            fgClasspathEntriesWithRules.put(key, new RuleEntry(rules, cpEntries));
        }
        return cpEntries;
    }

    private static IClasspathAttribute[] buildClasspathAttributes(IVMInstall vm, LibraryLocation lib, boolean overrideJavaDoc) {
        IPath annotationsPath;
        URL indexLocation;
        LinkedList<IClasspathAttribute> classpathAttributes = new LinkedList<IClasspathAttribute>();
        URL javadocLocation = lib.getJavadocLocation();
        if (overrideJavaDoc && javadocLocation == null) {
            javadocLocation = vm.getJavadocLocation();
        }
        if (javadocLocation != null) {
            IClasspathAttribute javadocCPAttribute = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation.toExternalForm());
            classpathAttributes.add(javadocCPAttribute);
        }
        if ((indexLocation = lib.getIndexLocation()) != null) {
            IClasspathAttribute indexCPLocation = JavaCore.newClasspathAttribute((String)"index_location", (String)indexLocation.toExternalForm());
            classpathAttributes.add(indexCPLocation);
        }
        if ((annotationsPath = lib.getExternalAnnotationsPath()) != null && !annotationsPath.isEmpty()) {
            IClasspathAttribute xAnnLocation = JavaCore.newClasspathAttribute((String)"annotationpath", (String)annotationsPath.toPortableString());
            classpathAttributes.add(xAnnLocation);
        }
        return classpathAttributes.toArray(new IClasspathAttribute[classpathAttributes.size()]);
    }

    public JREContainer(IVMInstall vm, IPath path, IJavaProject project) {
        this.fVMInstall = vm;
        this.fPath = path;
        this.fProject = project;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (LaunchingPlugin.DEBUG_JRE_CONTAINER) {
            LaunchingPlugin.trace("<JRE_CONTAINER> getClasspathEntries() " + this.toString());
            LaunchingPlugin.trace("\tJRE:\t" + this.fVMInstall.getName());
            LaunchingPlugin.trace("\tPath:\t" + this.getPath().toString());
            LaunchingPlugin.trace("\tProj:\t" + this.fProject.getProject().getName());
        }
        IClasspathEntry[] entries = JREContainer.getClasspathEntries(this.fVMInstall, this.getPath(), this.fProject);
        if (LaunchingPlugin.DEBUG_JRE_CONTAINER) {
            LaunchingPlugin.trace("\tResolved " + entries.length + " entries:");
        }
        return entries;
    }

    public String getDescription() {
        String environmentId = JavaRuntime.getExecutionEnvironmentId(this.getPath());
        String tag = null;
        tag = environmentId == null ? this.fVMInstall.getName() : environmentId;
        return NLS.bind((String)LaunchingMessages.JREContainer_JRE_System_Library_1, (Object)tag);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    static class RuleEntry {
        private IAccessRule[][] fRules = null;
        private IClasspathEntry[] fEntries = null;

        public RuleEntry(IAccessRule[][] rules, IClasspathEntry[] entries) {
            this.fRules = rules;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public boolean equals(Object obj) {
            IAccessRule[][] rules = null;
            if (obj instanceof RuleEntry) {
                rules = ((RuleEntry)obj).fRules;
            }
            if (obj instanceof IAccessRule[][]) {
                rules = (IAccessRule[][])obj;
            }
            if (this.fRules == rules) {
                return true;
            }
            if (rules != null && this.fRules.length == rules.length) {
                int i = 0;
                while (i < this.fRules.length) {
                    if (!RuleEntry.rulesEqual(this.fRules[i], rules[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        private static boolean rulesEqual(IAccessRule[] a, IAccessRule[] b) {
            if (a == b) {
                return true;
            }
            if (a.length != b.length) {
                return false;
            }
            int j = 0;
            while (j < a.length) {
                if (!a[j].equals(b[j])) {
                    return false;
                }
                ++j;
            }
            return true;
        }
    }

    static class RuleKey {
        private final String fEnvironmentId;
        private final IVMInstall fInstall;

        public RuleKey(IVMInstall install, String environmentId) {
            this.fInstall = install;
            this.fEnvironmentId = environmentId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RuleKey) {
                RuleKey key = (RuleKey)obj;
                return this.fEnvironmentId.equals(key.fEnvironmentId) && this.fInstall.equals(key.fInstall);
            }
            return false;
        }

        public int hashCode() {
            return this.fEnvironmentId.hashCode() + this.fInstall.hashCode();
        }
    }
}

